/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.UnaryQueryPIntSet;

public final class Predicates
extends UnaryQueryPIntSet {
    public Predicates(int r) {
        super(r);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    private static final void forAssertions(ReadGraphImpl graph, int r, final Predicates parent, IntSet set) throws DatabaseException {
        QueryCache.runnerPrincipalTypes(graph, r, parent, null, new SyncIntProcedure(set){
            IntProcedure proc;
            {
                this.proc = new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                        intSet.add(i);
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        this.dec(graph);
                    }
                };
            }

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) throws DatabaseException {
                this.inc();
                QueryCache.runnerAssertedPredicates(graph, type, parent, null, this.proc);
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }
        });
    }

    @Override
    public void compute(ReadGraphImpl graph, InternalProcedure<IntSet> procedure) throws DatabaseException {
        Predicates.computeForEach(graph, this.id, this, procedure);
    }

    public static void computeForEach(ReadGraphImpl graph, int r, Predicates entry, InternalProcedure<IntSet> procedure_) throws DatabaseException {
        InternalProcedure<IntSet> procedure = entry != null ? entry : procedure_;
        IntSet direct = QueryCache.resultDirectPredicates(graph, r, entry, null);
        final IntSet result = new IntSet(graph.processor.querySupport);
        Predicates.forAssertions(graph, r, entry, result);
        if (result.isEmpty()) {
            procedure.execute(graph, direct);
        } else {
            direct.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    result.add(value);
                    return true;
                }
            });
            procedure.execute(graph, result);
        }
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    public String toString() {
        return "Predicates[" + this.id + "]";
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(new IntSet(support));
    }

    @Override
    public int type() {
        return 1;
    }
}

