/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;

public final class ExternalReadEntry<T>
extends CacheEntryBase<AsyncProcedure<T>>
implements Listener<T> {
    final Deque<T> items = new LinkedList<T>();
    protected ExternalRead<T> id;
    protected QueryProcessor processor;
    protected boolean registered = false;

    @Override
    int makeHash() {
        return this.id.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.id;
    }

    @Override
    public void clearResult(QuerySupport support) {
    }

    @Override
    public void discard() {
        this.id.unregistered();
        this.id = null;
        this.processor = null;
        super.discard();
    }

    @Override
    public void setPending(QuerySupport querySupport) {
        this.statusOrException = PENDING;
        this.result = REQUIRES_COMPUTATION;
    }

    public ExternalReadEntry(ExternalRead<T> request, ReadGraphImpl graph) {
        assert (request != null);
        this.id = request;
        this.processor = graph.processor;
    }

    @Override
    public void except(Throwable t) {
        if (this.statusOrException != DISCARDED) {
            this.statusOrException = EXCEPTED;
            this.result = t;
        } else {
            this.result = t;
        }
        assert (this.isExcepted());
    }

    @Override
    public void setResult(Object result) {
        super.setResult(result);
        assert (!(result instanceof Throwable));
        assert (!this.isExcepted());
    }

    @Override
    public void setReady() {
        super.setReady();
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recompute(ReadGraphImpl graph) {
                Deque deque = ExternalReadEntry.this.items;
                synchronized (deque) {
                    if (!ExternalReadEntry.this.items.isEmpty()) {
                        ExternalReadEntry.this.setReady();
                        ExternalReadEntry.this.setResult(ExternalReadEntry.this.items.removeFirst());
                    }
                    if (!ExternalReadEntry.this.items.isEmpty()) {
                        graph.processor.updatePrimitive(ExternalReadEntry.this.id);
                    }
                }
            }

            @Override
            public void removeEntry(QueryProcessor processor) {
                processor.cache.remove(ExternalReadEntry.this);
            }

            @Override
            public int type() {
                return 1;
            }

            public String toString() {
                if (ExternalReadEntry.this.id == null) {
                    return "DISCARDED ExternalRead";
                }
                return ExternalReadEntry.this.id.toString();
            }
        };
    }

    public String toString() {
        if (this.id == null) {
            return "DISCARDED ExternalRead " + System.identityHashCode(this);
        }
        return this.id.toString() + " " + System.identityHashCode(this);
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, AsyncProcedure<T> procedure) {
        AsyncProcedure<T> proc = procedure;
        if (this.isExcepted()) {
            proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
        } else {
            proc.execute((AsyncReadGraph)graph, this.getResult());
        }
        return this.getResult();
    }

    @Override
    void prepareRecompute(QuerySupport querySupport) {
    }

    public Object compute(ReadGraphImpl graph, AsyncProcedure<T> procedure) throws DatabaseException {
        try {
            ReadGraphImpl queryGraph = graph.withParent(this, null, true);
            if (!this.registered) {
                this.id.register((ReadGraph)queryGraph, (Listener)this);
                this.registered = true;
            }
            queryGraph.asyncBarrier.dec();
            queryGraph.asyncBarrier.waitBarrier(this.id, queryGraph);
        }
        catch (Throwable t) {
            this.except(t);
        }
        this.performFromCache(graph, procedure);
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(T result) {
        if (this.result == REQUIRES_COMPUTATION) {
            this.setResult(result);
            this.setReady();
        } else {
            Deque<T> deque = this.items;
            synchronized (deque) {
                if (!this.items.isEmpty()) {
                    T last = this.items.getLast();
                    if (!result.equals(last)) {
                        this.items.addLast(result);
                        this.processor.updatePrimitive(this.id);
                    }
                } else {
                    Object last = this.getResult();
                    if (!Objects.equals(last, result)) {
                        this.items.addLast(result);
                        this.processor.updatePrimitive(this.id);
                    }
                }
            }
        }
    }

    public void exception(Throwable t) {
        this.except(t);
    }

    public boolean isDisposed() {
        return this.registered && (this.isDiscarded() || !this.processor.isBound(this));
    }

    @Override
    public String classId() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalReadEntry other = (ExternalReadEntry)obj;
        return Objects.equals(this.id, other.id);
    }
}

