/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CollectionBinaryQuery;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;

public final class DirectObjects
extends CollectionBinaryQuery<IntProcedure>
implements IntProcedure {
    public DirectObjects(int r1, int r2) {
        super(r1, r2);
    }

    @Override
    public int type() {
        return 0;
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    public Object compute(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        DirectObjects.computeForEach(graph, this.r1(), this.r2(), this, procedure);
        return this.getResult();
    }

    public static void computeForEach(ReadGraphImpl graph, int r1, int r2, DirectObjects entry, IntProcedure procedure_) throws DatabaseException {
        IntProcedure procedure = entry != null ? entry : procedure_;
        QueryProcessor processor = graph.processor;
        processor.querySupport.ensureLoaded(graph, r1, r2);
        processor.querySupport.getObjects(graph, r1, r2, procedure);
        procedure.finished(graph);
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    public String toString() {
        return "DirectObjects[" + this.r1() + " - " + this.r2() + "]";
    }

    @Override
    public void setReady() {
        this.statusOrException = READY;
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return this.getResult();
        }
        IntArray value = (IntArray)this.getResult();
        if (value.data == null) {
            if (value.sizeOrData != -1) {
                procedure.execute(graph, value.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < value.sizeOrData) {
                procedure.execute(graph, value.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
        return value;
    }

    @Override
    public void recompute(ReadGraphImpl graph) throws DatabaseException {
        this.compute(graph, new IntProcedure(){

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute.", t);
            }

            @Override
            public void execute(ReadGraphImpl graphd, int i) {
            }
        });
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutableForReading(this.r1());
    }

    @Override
    public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
        IntArray value = (IntArray)this.getResult();
        value.add(i);
    }

    @Override
    public void finished(ReadGraphImpl graph) throws DatabaseException {
        this.setReady();
    }

    @Override
    public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
        this.except(throwable);
    }
}

