/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.List;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializer;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheEntryBase<Procedure>
extends CacheEntry<Procedure> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheEntryBase.class);
    public static final short UNDEFINED_LEVEL = 5;
    public short level = (short)5;
    public static final CacheEntryBase[] NONE = new CacheEntryBase[0];
    static Object NO_RESULT = new Object(){

        public String toString() {
            return "NO_RESULT";
        }
    };
    protected static Object INVALID_RESULT = new Object(){

        public String toString() {
            return "INVALID_RESULT";
        }
    };
    protected static Object READY = new Object(){

        public String toString() {
            return "READY";
        }
    };
    protected static Object PENDING = new Object(){

        public String toString() {
            return "PENDING";
        }
    };
    protected static Object DISCARDED = new Object(){

        public String toString() {
            return "DISCARDED";
        }
    };
    protected static Object REQUIRES_COMPUTATION = new Object(){

        public String toString() {
            return "REFUTED";
        }
    };
    protected static Object EXCEPTED = new Object(){

        public String toString() {
            return "EXCEPTED";
        }
    };
    public Object statusOrException = REQUIRES_COMPUTATION;
    private int hash = 0;
    Object result = NO_RESULT;

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = this.makeHash();
        }
        return this.hash;
    }

    abstract int makeHash();

    @Override
    public final boolean isFresh() {
        return REQUIRES_COMPUTATION == this.statusOrException;
    }

    @Override
    public void setReady() {
        assert (this.result != NO_RESULT);
        this.statusOrException = READY;
    }

    @Override
    @Deprecated
    public final boolean isReady() {
        return READY == this.statusOrException || EXCEPTED == this.statusOrException;
    }

    @Override
    public void discard() {
        this.statusOrException = DISCARDED;
        this.result = NO_RESULT;
    }

    @Override
    public final boolean isDiscarded() {
        return DISCARDED == this.statusOrException;
    }

    @Override
    public final void refute() {
        this.statusOrException = REQUIRES_COMPUTATION;
    }

    @Override
    public final boolean isRefuted() {
        return REQUIRES_COMPUTATION == this.statusOrException;
    }

    @Override
    public void except(Throwable throwable) {
        if (this.statusOrException != DISCARDED) {
            this.statusOrException = EXCEPTED;
            this.result = throwable;
        } else {
            LOGGER.warn("Cache entry got excepted status after being discarded: " + this.getClass().getSimpleName(), throwable);
            this.result = throwable;
        }
    }

    public final void checkAndThrow() throws DatabaseException {
        if (this.isExcepted()) {
            Throwable throwable = (Throwable)this.result;
            if (throwable instanceof DatabaseException) {
                throw (DatabaseException)throwable;
            }
            throw new DatabaseException(throwable);
        }
    }

    @Override
    public final boolean isExcepted() {
        return EXCEPTED == this.statusOrException;
    }

    @Override
    public void setPending(QuerySupport querySupport) {
        this.statusOrException = PENDING;
        this.clearResult(querySupport);
    }

    @Override
    public final boolean isPending() {
        return PENDING == this.statusOrException;
    }

    public final boolean requiresComputation() {
        return REQUIRES_COMPUTATION == this.statusOrException;
    }

    public final boolean assertPending() {
        boolean result = this.isPending();
        if (!result) {
            LOGGER.warn("Assertion failed, expected pending, got " + String.valueOf(this.statusOrException));
        }
        return result;
    }

    public final boolean assertNotPending() {
        boolean result;
        boolean bl = result = !this.isPending();
        if (!result) {
            new Exception(String.valueOf(this) + ": Assertion failed, expected not pending, got " + String.valueOf(this.statusOrException)).printStackTrace();
        }
        return result;
    }

    public final boolean assertNotDiscarded() {
        boolean result;
        boolean bl = result = !this.isDiscarded();
        if (!result) {
            new Exception(String.valueOf(this) + ": Assertion failed, expected not discarded, got " + String.valueOf(this.statusOrException)).printStackTrace();
        }
        return result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public final <T> T getResult() {
        assert (this.statusOrException != DISCARDED);
        return (T)this.result;
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(NO_RESULT);
    }

    protected String internalError() {
        return this.toString() + " " + String.valueOf(this.statusOrException) + " " + String.valueOf(this.result);
    }

    protected boolean handleException(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    protected boolean handleException(ReadGraphImpl graph, TripleIntProcedure procedure) throws DatabaseException {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    protected <T> boolean handleException(ReadGraphImpl graph, InternalProcedure<T> procedure) throws DatabaseException {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) throws DatabaseException {
        return false;
    }

    @Override
    boolean shouldBeCollected() {
        return true;
    }

    @Override
    short getLevel() {
        return this.level;
    }

    @Override
    short setLevel(short level) {
        short existing = this.level;
        this.level = level;
        return existing;
    }

    @Override
    void prepareRecompute(QuerySupport querySupport) {
        this.setPending(querySupport);
    }

    @Override
    public Object getOriginalRequest() {
        return this.getQuery();
    }

    public String classId() {
        return this.getClass().getName();
    }

    public void serializeKey(QuerySerializer serializer) {
        throw new IllegalStateException("Cannot serialize query key for " + String.valueOf(this));
    }

    public void serializeValue(QuerySerializer serializer) {
        throw new IllegalStateException("Cannot serialize query value for " + String.valueOf(this));
    }

    public void serializeParents(QuerySerializer serializer) {
        List<CacheEntry> ps = serializer.getQueryProcessor().listening.getParents(this);
        int sizePos = serializer.writeUnknownSize();
        int actual = 0;
        for (CacheEntry entry : ps) {
            CacheEntryBase b = (CacheEntryBase)entry;
            String cid = b.classId();
            if (cid == null) continue;
            serializer.serializeId(b.classId());
            b.serializeKey(serializer);
            ++actual;
        }
        serializer.setUnknownSize(sizePos, actual);
    }

    public long cluster(QueryProcessor processor) {
        throw new IllegalStateException("Cannot compute query cluster for " + String.valueOf(this));
    }

    public void serialize(QuerySerializer serializer) {
        serializer.serializeId(this.classId());
        this.serializeKey(serializer);
        this.serializeValue(serializer);
        this.serializeParents(serializer);
    }
}

