/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.graph.BarrierTracing;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBarrierImpl
extends AtomicInteger
implements QueryProcessor.AsyncBarrier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncBarrierImpl.class);
    private static final long serialVersionUID = 4724463372850048672L;
    static final int WAIT_TIME = 5000;
    private final Runnable callback;
    private final boolean needsToBlock;
    AsyncBarrierImpl caller;

    public AsyncBarrierImpl(AsyncBarrierImpl caller, CacheEntry<?> entry, Runnable callback, boolean needsToBlock) {
        super(1);
        this.caller = caller;
        this.callback = callback;
        this.needsToBlock = needsToBlock;
        if (caller != null) {
            caller.inc(this);
        }
    }

    public QueryProcessor.AsyncBarrier getBlockingBarrier() {
        if (this.needsToBlock) {
            return this;
        }
        if (this.caller == null) {
            return null;
        }
        return this.caller.getBlockingBarrier();
    }

    @Override
    public boolean isBlocking() {
        return this.needsToBlock;
    }

    private boolean isDone() {
        return this.get() == 0;
    }

    @Override
    public void inc() {
        if (this.isDone()) {
            return;
        }
        this.inc(null);
    }

    void inc(Object id) {
        if (this.isDone()) {
            throw new IllegalStateException("restart");
        }
        int count = this.incrementAndGet();
    }

    @Override
    public void dec() {
        this.dec(null);
    }

    public void dec(Object id) {
        int count = this.decrementAndGet();
        if (count < 1) {
            if (count == 0 && this.caller != null) {
                this.caller.dec(this);
            }
            if (count < 0) {
                LOGGER.error("Database request processing error. The application code has performed illegal actions (probably called multiple times the execute or exception method of a single result request.", (Throwable)new Exception());
            }
            assert (count >= 0);
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }

    public static String report(AsyncBarrierImpl barrier) {
        BarrierTracing.Debugger debugger = BarrierTracing.debuggerMap.get(barrier);
        Object e = debugger.entry;
        if (e != null) {
            return e.toString();
        }
        return "Barrier@" + System.identityHashCode(barrier);
    }

    public static void printReverse(AsyncBarrierImpl barrier, int indent) {
        if (barrier.get() == 0) {
            return;
        }
        int i = 0;
        while (i < indent) {
            System.err.print(" ");
            ++i;
        }
        System.err.println("[" + barrier.get() + " requests]: " + AsyncBarrierImpl.report(barrier));
        Collection<AsyncBarrierImpl> children = BarrierTracing.reverseLookup.get(barrier);
        if (children != null) {
            for (AsyncBarrierImpl child : children) {
                AsyncBarrierImpl.printReverse(child, indent + 2);
            }
        }
    }

    @Override
    public void waitBarrier(Object request, ReadGraphImpl impl) {
        if (this.isDone()) {
            return;
        }
        if (this.get() > 0) {
            long waitCount = 0L;
            while (this.get() != 0) {
                boolean executed = impl.performPending();
                if (executed) {
                    waitCount = 0L;
                }
                if (++waitCount > 100L) {
                    Thread.yield();
                }
                if (waitCount > 1000L) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (waitCount <= 5000L) continue;
                System.err.println("AsyncBarrierImpl.waitBarrier(" + String.valueOf(request) + ") is taking long to execute, so far " + waitCount / 1000L + " s.");
                throw new RuntimeDatabaseException("Request timed out.");
            }
        }
    }

    public void assertReady() {
        int current = this.get();
        if (current != 0) {
            throw new AssertionError((Object)("Barrier was not finished (pending=" + current + ")."));
        }
    }

    public void report() {
    }

    @Override
    public String toString() {
        return AsyncBarrierImpl.report(this);
    }
}

