package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;

public class URIToResourceFactory extends QueryFactoryBase {

    @Override
    public CacheEntryBase readKeyAndValue(QueryDeserializer deserializer) throws DatabaseException {
        URIToResource result = reference(deserializer);
        int value = deserializer.readResource();
        result.setResult(value);
        result.setReady();
        return result;
    }
    
    @Override
    public <T extends CacheEntryBase> T reference(QueryDeserializer deserializer) throws DatabaseException {
        return (T)deserializer.readURIToResource();
    }

}
