package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;

abstract public class QueryFactoryBase implements QueryFactory {

    abstract protected CacheEntryBase readKeyAndValue(QueryDeserializer deserializer) throws DatabaseException;

    public void readParents(QueryDeserializer deserializer, CacheEntryBase entry) throws DatabaseException {
        int ps = deserializer.readLE4();
        for(int i=0;i<ps;i++) {
            QueryFactory qf = deserializer.readFactory();
            CacheEntryBase ceb = qf.reference(deserializer);
            deserializer.listening.addParent(entry, ceb);
        }
    }
    
    @Override
    final public CacheEntryBase read(QueryDeserializer deserializer) throws DatabaseException {
        CacheEntryBase entry = readKeyAndValue(deserializer);
        readParents(deserializer, entry);
        return entry;
    }

}
