package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;

public class DirectPredicatesFactory extends QueryFactoryBase {

    @Override
    public CacheEntryBase readKeyAndValue(QueryDeserializer deserializer) throws DatabaseException {
        DirectPredicates result = reference(deserializer);
        IntSet is = IntSet.deserialize(deserializer);
        result.setResult(is);
        result.setReady();
        return result;
    }
    
    @Override
    public <T extends CacheEntryBase> T reference(QueryDeserializer deserializer) throws DatabaseException {
        return (T)deserializer.readDirectPredicates();
    }

}
