/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.common.exception.DebugException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;

public final class DirectPredicates extends UnaryQueryPIntSet {

	public DirectPredicates(final int resource) {
		super(resource);
	}

	@Override
	public final void removeEntry(QueryProcessor provider) {
		provider.cache.remove(this);
	}

	@Override
	public void compute(ReadGraphImpl graph, InternalProcedure<IntSet> procedure) throws DatabaseException {
		computeForEach(graph, id, this, procedure);
	}

	public static Object computeForEach(ReadGraphImpl graph, int id, final DirectPredicates entry, final InternalProcedure<IntSet> procedure_) throws DatabaseException {

		InternalProcedure<IntSet> procedure = entry != null ? entry : procedure_;

		graph.processor.querySupport.ensureLoaded(graph, id);

		final IntSet list = new IntSet(graph.processor.querySupport);

		graph.processor.querySupport.getPredicates(graph, id, new IntProcedure() {

			@Override
			public void execute(ReadGraphImpl graph, int i) {
				list.add(i);
			}

			@Override
			public void finished(ReadGraphImpl graph) {
			}

			@Override
			public void exception(ReadGraphImpl graph, Throwable t) {
				if(DebugException.DEBUG) new DebugException(t).printStackTrace();
			}

		});

		procedure.execute(graph, list);

		if(entry != null) entry.performFromCache(graph, procedure_);

		return list;

	}

	@Override
	public String toString() {
		return "DirectPredicates[" + id + "]";
	}

}
