package org.simantics.db.impl.internal;

import java.util.Collection;

import org.simantics.db.ExternalValueSupport;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.utils.datastructures.Pair;

/**
 * A database {@link Session} service for registering and retrieving random
 * access binary instances related to a session.
 * 
 * <p>
 * This service is internal to the implementation and must not be used
 * elsewhere.
 * </p>
 * 
 * @author Tuukka Lehtonen
 * 
 * @see ExternalValueSupport
 */
public interface RandomAccessValueSupport {

	/**
	 * Registers the specified value with the specified resource.
	 * 
	 * @param resource
	 * @param data
	 * @throws IllegalStateException
	 *             if a previous registration already exists for the specified
	 *             resource
	 */
	void put(Resource resource, ResourceData data);

	/**
	 * @param Resource
	 * @return currently registered value attached to the specified resource
	 */
	ResourceData get(Resource resource);

	/**
	 * @return currently registered entries
	 */
	Collection<Pair<Resource, ResourceData>> entries();

	/**
	 * Removes all value registrations from this registry.
	 * 
	 * @return the set of previously registered values
	 */
	Collection<Pair<Resource, ResourceData>> removeAll();

}
