package org.simantics.db.impl.graph;

import org.simantics.db.DevelopmentEvents.ClaimEvent;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;

public class ClaimEventImpl implements ClaimEvent {

	final private VirtualGraph virtualGraph;
	final private Resource subject;
	final private Resource predicate;
	final private Resource object;
	final private String text;
	
	public ClaimEventImpl(ReadGraph graph, VirtualGraph virtualGraph, Resource subject, Resource predicate, Resource object, String text) {
		this.virtualGraph = virtualGraph;
		this.subject = subject;
		this.predicate = predicate;
		this.object = object;
		this.text = text;
	}
	
	@Override
	public VirtualGraph getVirtualGraph() {
		return virtualGraph;
	}

	@Override
	public Resource getSubject() {
		return subject;
	}

	@Override
	public Resource getPredicate() {
		return predicate;
	}

	@Override
	public Resource getObject() {
		return object;
	}
	
	@Override
	public String toString() {
		return text;
	}
	
}
