/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils.traverser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.traverser.TraverseQuery;

public class TraverseQueryBuilder {
    private static final Resource[] NO_RESOURCES = new Resource[0];
    public Set<Resource> startResources = new HashSet<Resource>();
    public Set<Resource> relationsToFollow = new HashSet<Resource>();
    public Set<Resource> instanceOfToFollowTo = new HashSet<Resource>();
    public Set<Resource> instanceOfToAddToResult = new HashSet<Resource>();
    public Set<Resource> inheritedFromToFollowTo = new HashSet<Resource>();
    public Set<Resource> inheritedFromToAddToResult = new HashSet<Resource>();

    public void setStartResource(Resource r) {
        this.startResources.clear();
        this.startResources.add(r);
    }

    public void setStartResources(Collection<Resource> r) {
        this.startResources.clear();
        this.startResources.addAll(r);
    }

    public void addStartResource(Resource r) {
        this.startResources.add(r);
    }

    public void followInstanceOf(Resource r) {
        this.instanceOfToFollowTo.add(r);
    }

    public void followInheritedFrom(Resource r) {
        this.inheritedFromToFollowTo.add(r);
    }

    public void followRelation(Resource r) {
        this.relationsToFollow.add(r);
    }

    public void returnInstanceOf(Resource r) {
        this.instanceOfToAddToResult.add(r);
    }

    public void returnInheritedFrom(Resource r) {
        this.inheritedFromToAddToResult.add(r);
    }

    public void followAndReturnInstanceOf(Resource r) {
        this.instanceOfToFollowTo.add(r);
        this.instanceOfToAddToResult.add(r);
    }

    public void followAndReturnInheritedFrom(Resource r) {
        this.inheritedFromToFollowTo.add(r);
        this.inheritedFromToAddToResult.add(r);
    }

    public void clear() {
        this.startResources.clear();
        this.instanceOfToFollowTo.clear();
        this.relationsToFollow.clear();
        this.instanceOfToAddToResult.clear();
    }

    public TraverseQuery build() {
        return new TraverseQuery(this.startResources.toArray(NO_RESOURCES), this.instanceOfToFollowTo.toArray(NO_RESOURCES), this.relationsToFollow.toArray(NO_RESOURCES), this.instanceOfToAddToResult.toArray(NO_RESOURCES), this.inheritedFromToFollowTo.toArray(NO_RESOURCES), this.inheritedFromToAddToResult.toArray(NO_RESOURCES));
    }
}

