/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class LiteralFileUtil {
    public static void copyByteArrayToFile(ReadGraph g, Resource source, File target) throws DatabaseException, IOException {
        byte[] data = (byte[])g.getValue(source, (Binding)Bindings.BYTE_ARRAY);
        try (FileOutputStream stream = new FileOutputStream(target);){
            int pos = 0;
            while (pos < data.length) {
                int len = Math.min(65536, data.length - pos);
                ((OutputStream)stream).write(data, pos, len);
                pos += len;
            }
        }
    }

    public static void copyByteArrayToFile(ReadGraph g, Resource subject, Resource predicate, File target) throws DatabaseException, IOException {
        Resource source = g.getSingleObject(subject, predicate);
        LiteralFileUtil.copyByteArrayToFile(g, source, target);
    }

    public static void copyRandomAccessBinaryToFile(ReadGraph g, Resource source, File target) throws DatabaseException, IOException {
        try (FileOutputStream stream = new FileOutputStream(target);){
            RandomAccessBinary rab = g.getRandomAccessBinary(source);
            rab.position(4L);
            ByteBuffer bb = ByteBuffer.wrap(new byte[65536]);
            byte[] bbArray = bb.array();
            while (rab.position() < rab.length()) {
                rab.readFully(bb, (int)Math.min((long)bbArray.length, rab.length() - rab.position()));
                ((OutputStream)stream).write(bbArray, 0, bb.position());
                bb.position(0);
            }
        }
    }

    public static void copyRandomAccessBinaryFromFile(File source, RandomAccessBinary rab) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[65536]);
        FileInputStream stream = new FileInputStream(source);
        FileChannel channel = stream.getChannel();
        try {
            rab.position(0L);
            rab.writeInt((int)source.length());
            while (channel.read(byteBuffer) != -1) {
                byteBuffer.limit(byteBuffer.position());
                byteBuffer.position(0);
                rab.writeFully(byteBuffer);
                byteBuffer.position(0);
            }
        }
        finally {
            stream.close();
        }
        rab.setLength(rab.position());
        rab.flush();
    }

    public static void copyRandomAccessBinaryToFile(ReadGraph g, Resource subject, Resource predicate, File target) throws DatabaseException, IOException {
        Resource source = g.getSingleObject(subject, predicate);
        LiteralFileUtil.copyRandomAccessBinaryToFile(g, source, target);
    }

    public static void copyToFileWithBinding(ReadGraph g, Resource source, File target, Binding binding) throws DatabaseException, IOException {
        Object value = g.getValue(source, binding);
        Serializer s = Bindings.getSerializerUnchecked((Binding)binding);
        s.serialize(value, target);
    }

    public static void copyToFileWithBinding(ReadGraph g, Resource subject, Resource predicate, File target, Binding binding) throws DatabaseException, IOException {
        Resource source = g.getSingleObject(subject, predicate);
        LiteralFileUtil.copyToFileWithBinding(g, source, target, binding);
    }

    public static void copyToFileAsVariant(ReadGraph g, Resource source, File target, Binding binding) throws DatabaseException, IOException {
        Object value = g.getValue(source, binding);
        Files.createFile((File)target, (Binding)binding, (Object)value);
    }

    public static void copyToFileAsVariant(ReadGraph g, Resource source, File target) throws DatabaseException, IOException {
        Datatype type = g.getDataType(source);
        Binding binding = Bindings.getBinding((Datatype)type);
        LiteralFileUtil.copyToFileAsVariant(g, source, target, binding);
    }

    public static void copyToFileAsVariant(ReadGraph g, Resource subject, Resource predicate, File target) throws DatabaseException, IOException {
        Resource source = g.getSingleObject(subject, predicate);
        LiteralFileUtil.copyToFileAsVariant(g, source, target);
    }

    public static void copyByteArrayFromFile(WriteGraph g, File source, Resource target) throws DatabaseException, IOException {
        FileInputStream stream = new FileInputStream(source);
        byte[] data = new byte[(int)source.length()];
        ((InputStream)stream).read(data);
        ((InputStream)stream).close();
        g.claimValue(target, (Object)data, (Binding)Bindings.BYTE_ARRAY);
    }

    public static void copyByteArrayFromFile(WriteGraph g, File source, Resource subject, Resource predicate) throws DatabaseException, IOException {
        FileInputStream stream = new FileInputStream(source);
        byte[] data = new byte[(int)source.length()];
        ((InputStream)stream).read(data);
        ((InputStream)stream).close();
        g.claimLiteral(subject, predicate, (Object)data, (Binding)Bindings.BYTE_ARRAY);
    }

    public static void streamingCopyByteArrayFromFile(WriteGraph g, File source, Resource subject, Resource predicate) throws DatabaseException, IOException {
        Resource target = g.getPossibleObject(subject, predicate);
        if (target == null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            target = g.newResource();
            g.claim(target, L0.InstanceOf, null, L0.ByteArray);
            g.claim(subject, predicate, target);
        }
        try (FileInputStream stream = new FileInputStream(source);){
            LiteralFileUtil.copyStreamToRandomAccessBinary(g, stream, target);
        }
    }

    public static void copyByteArrayFromStream(WriteGraph g, InputStream source, Resource target) throws IOException, DatabaseException {
        int count;
        byte[] buffer = new byte[65536];
        int pos = 0;
        while ((count = source.read(buffer, pos, buffer.length - pos)) > 0) {
            if ((pos += count) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, pos * 3 / 2);
        }
        buffer = Arrays.copyOf(buffer, pos);
        g.claimValue(target, (Object)buffer, (Binding)Bindings.BYTE_ARRAY);
    }

    public static void copyStreamToRandomAccessBinary(WriteGraph g, InputStream source, Resource target) throws IOException, DatabaseException {
        int count;
        RandomAccessBinary rab = g.getRandomAccessBinary(target);
        byte[] buffer = new byte[65536];
        if (rab.length() < 4L) {
            rab.setLength(4L);
        }
        rab.position(4L);
        int length = 0;
        while ((count = source.read(buffer, 0, buffer.length)) > 0) {
            rab.write(buffer, 0, count);
            length += count;
        }
        rab.position(0L);
        rab.writeInt(length);
        rab.setLength((long)(length + 4));
        rab.flush();
    }
}

