/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.AdaptValue;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;

public class Functions {
    private static DatabaseException findPossibleRootException(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof DatabaseException) {
            return (DatabaseException)t;
        }
        if (t instanceof RuntimeException || t instanceof InvocationTargetException) {
            return Functions.findPossibleRootException(t.getCause());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T exec(RequestProcessor rp, Resource function, Object ... parameters) throws DatabaseException {
        String packageName;
        Object op = rp.syncRequest((Read)new AdaptValue(function));
        if (parameters.length > 0 && parameters[0] instanceof ReadGraph && (packageName = op.getClass().getPackageName()).startsWith("scl.")) {
            parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
        }
        try {
            if (!(rp instanceof ReadGraph)) return (T)((Function)op).applyArray(parameters);
            SCLContext sclContext = SCLContext.getCurrent();
            Object oldGraph = sclContext.put((Object)"graph", (Object)rp);
            try {
                Object object = ((Function)op).applyArray(parameters);
                return (T)object;
            }
            catch (Throwable t) {
                if (!(t instanceof DatabaseException)) throw new DatabaseException(t);
                throw (DatabaseException)t;
            }
            finally {
                sclContext.put((Object)"graph", oldGraph);
            }
        }
        catch (RuntimeException e) {
            DatabaseException dte = Functions.findPossibleRootException(e);
            if (dte == null) throw new DatabaseException((Throwable)e);
            throw dte;
        }
    }
}

