/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.single.wrapper;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.procedure.AsyncProcedure;

public final class SingleFunctionalOrNullProcedure<Result>
extends AsyncMultiProcedureAdapter<Result> {
    final String location;
    final AsyncProcedure<Result> procedure;
    final AtomicBoolean found = new AtomicBoolean(false);
    final AtomicBoolean guard = new AtomicBoolean(false);
    final AtomicBoolean exception = new AtomicBoolean(false);

    public SingleFunctionalOrNullProcedure(String location, AsyncProcedure<Result> procedure) {
        this.location = location;
        this.procedure = procedure;
    }

    @Override
    public void execute(AsyncReadGraph graph, Result result) {
        assert (!this.guard.get());
        if (this.found.compareAndSet(false, true)) {
            this.procedure.execute(graph, result);
        } else if (this.exception.compareAndSet(false, true)) {
            this.procedure.exception(graph, (Throwable)new ManyObjectsForFunctionalRelationException(this.location + " -> " + String.valueOf(this.procedure)));
        }
    }

    @Override
    public void finished(AsyncReadGraph graph) {
        assert (!this.guard.get());
        this.guard.set(true);
        if (this.found.compareAndSet(false, true)) {
            this.procedure.execute(graph, null);
        }
    }

    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
        this.procedure.exception(graph, t);
    }

    public String toString() {
        return "SingleFunctionalOrNullProcedure -> " + String.valueOf(this.procedure);
    }
}

