/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.issue;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class StandardIssue
implements Issue {
    public final Resource type;
    public final Resource[] contexts;
    public final int hash;

    public StandardIssue(Resource type, Resource ... contexts) {
        this.type = type;
        this.contexts = contexts;
        this.hash = this.makeHashCode();
    }

    public StandardIssue(Resource type, Collection<Resource> contexts) {
        this.type = type;
        this.contexts = contexts.toArray(new Resource[contexts.size()]);
        this.hash = this.makeHashCode();
    }

    public void writeAdditionalContext(WriteGraph graph, Resource issue) throws DatabaseException {
        IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
        graph.claim(issue, IR.Issue_HasContext, IR.Issue_HasContext_Inverse, this.contexts[0]);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(this.contexts[0], L0.PartOf);
        if (parent != null) {
            graph.claim(issue, IR.Issue_HasContext, IR.Issue_HasContext_Inverse, parent);
        }
    }

    public Resource write(WriteGraph graph, Resource source) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
        Resource model = (Resource)graph.syncRequest((Read)new IndexRoot(source), TransientCacheListener.instance());
        Resource issue = graph.newResource();
        graph.claim(issue, L0.InstanceOf, null, this.type);
        graph.addLiteral(issue, L0.HasName, L0.NameOf, L0.String, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claim(issue, IR.Issue_HasContexts, IR.Issue_HasContexts_Inverse, ListUtils.create(graph, IR.Issue_ContextList, this.contexts));
        this.writeAdditionalContext(graph, issue);
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String created = format.format(Calendar.getInstance().getTime());
        graph.addLiteral(issue, IR.Issue_creationTime, IR.Issue_creationTime_Inverse, L0.String, (Object)created, (Binding)Bindings.STRING);
        graph.claim(source, IR.IssueSource_Manages, IR.IssueSource_Manages_Inverse, issue);
        graph.claim(model, L0.ConsistsOf, L0.PartOf, issue);
        return issue;
    }

    public String toString() {
        return Arrays.toString(this.contexts);
    }

    public Resource getType() {
        return this.type;
    }

    public Object getMainContext() {
        return this.contexts.length > 0 ? this.contexts[0] : null;
    }

    public Set<Resource> getContexts() {
        HashSet<Resource> result = new HashSet<Resource>();
        Resource[] resourceArray = this.contexts;
        int n = this.contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource context = resourceArray[n2];
            result.add(context);
            ++n2;
        }
        return result;
    }

    private int makeHashCode() {
        return this.type.hashCode() ^ Arrays.hashCode(this.contexts);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StandardIssue)) {
            return false;
        }
        StandardIssue other = (StandardIssue)obj;
        if (!ObjectUtils.objectEquals((Object)this.type, (Object)other.type)) {
            return false;
        }
        return Arrays.equals(this.contexts, other.contexts);
    }
}

