package org.simantics.db.common.utils;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;

public class VersionMapRequest extends ResourceRead<VersionMap> {

	public VersionMapRequest(Resource resource) {
		super(resource);
	}

	@Override
	public VersionMap perform(ReadGraph graph) throws DatabaseException {
		VersionMap result = new VersionMap();
		Map<String,Resource> childMap = graph.syncRequest(new UnescapedChildMapOfResource(resource));
		for(Map.Entry<String,Resource> entry : childMap.entrySet()) {
			String s = entry.getKey();
			Resource r = entry.getValue();
			int pos = s.lastIndexOf('@');
			if(pos == -1)  {
				result.add(s, new NamedResource("", r));
			} else {
				String base = s.substring(0, pos);
				String version = s.substring(pos+1);
				result.add(base, new NamedResource(version, r));
			}
		}
		return result;
	}

}
