/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import gnu.trove.map.hash.THashMap;

import java.util.Collection;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class FunctionalStatementMapOfResource extends ResourceRead<Map<String, Resource>> {

    public FunctionalStatementMapOfResource(Resource resource) {
        super(resource);
    }

    @Override
    public Map<String,Resource> perform(ReadGraph graph) throws DatabaseException {

        Layer0 L0 = Layer0.getInstance(graph);
        Collection<Resource> predicates = graph.getPredicates(resource); 
        THashMap<String, Resource> result = new THashMap<String, Resource>(predicates.size());
        for(Resource predicate : predicates) {
            if(graph.isInstanceOf(predicate, L0.FunctionalRelation)) {
                String name = graph.getPossibleRelatedValue(predicate, L0.HasName, Bindings.STRING);
                Resource obj = graph.getSingleObject(resource, predicate);
                if(name != null)
                    result.put(name, obj);
            }
        }
        return result;

    }

}
