package org.simantics.db.common.request;

import org.simantics.db.ComputationalValue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.FunctionImpl3;

/**
 * Adapts a resource to (SCL) value.
 * @author Hannu Niemist&ouml;
 */
public class AdaptValue extends ResourceRead<Object> {

    public AdaptValue(Resource resource) {
        super(resource);
    }

    public static final FunctionImpl3<ReadGraph,Resource,Object,Object> functionApplication = new FunctionImpl3<ReadGraph,Resource,Object,Object>() {

		@Override
		public Object apply(ReadGraph graph, Resource resource, Object context) {
			try {
				return Functions.exec(graph, resource, graph, resource, context);
			} catch (DatabaseException e) {
				throw new RuntimeDatabaseException(e);
			}
		}

	};

    @Override
    public Object perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = graph.l0();
        if (L0.Functions_functionApplication.equalsResource(resource))
            return functionApplication;
        ComputationalValue ev = graph.adapt(resource, ComputationalValue.class);
        return ev.getValue(graph, resource);
    }

}
