/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.AsyncListenerSupport;

abstract public class SingleSetAsyncListenerDelegate<T> extends SingleSetAsyncListener<T> {
    
    final private AsyncListenerSupport support;
    
    public SingleSetAsyncListenerDelegate(AsyncListenerSupport support) {
        this.support = support;
    }

    @Override
    final public void exception(AsyncReadGraph graph, Throwable throwable) {
        support.exception(graph, throwable);
    }

    @Override
    final public boolean isDisposed() {
        return support.isDisposed();
    }
	
}
