/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadExt;
import org.simantics.db.request.RequestFlags;

final public class PossibleResource extends UnaryRead<String, Resource> implements ReadExt {

	public PossibleResource(String URI) {
		super(URI);
		assert(URI != null);
	}

	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {
		return graph.getPossibleResource(parameter);
	}
	
	@Override
	public boolean isImmutable(ReadGraph graph) throws DatabaseException {
		return false;
	}
	
	@Override
	public int getType() {
		return RequestFlags.IMMEDIATE_UPDATE;
	}

}
