/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.streaming;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.Endian;
import org.simantics.databoard.util.binary.UTF8;

public class DataWriter {
    private static final Serializer DATATYPE_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.getBindingUnchecked(Datatype.class));
    private final DataOutput out;

    public DataWriter(DataOutput out) {
        this.out = out;
    }

    public DataWriter(OutputStream stream) {
        this.out = new DataOutputStream(stream);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.out.write(value ? 1 : 0);
    }

    public void writeByte(byte value) throws IOException {
        this.out.write(value);
    }

    public void writeInteger(int value) throws IOException {
        this.out.writeInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.out.writeLong(value);
    }

    public void writeFloat(float value) throws IOException {
        this.out.writeFloat(value);
    }

    public void writeDouble(double value) throws IOException {
        this.out.writeDouble(value);
    }

    public void writeString(String value) throws IOException {
        int utflen = UTF8.getModifiedUTF8EncodingByteLength(value);
        Endian.writeDynamicUInt32(this.out, utflen);
        UTF8.writeModifiedUTF(this.out, value);
    }

    public void writeDatatype(Datatype datatype) throws IOException {
        DATATYPE_SERIALIZER.serialize(this.out, (Object)datatype);
    }

    public void beginVariableLengthArray(int length) throws IOException {
        this.out.writeInt(length);
    }

    public void beginMap(int size) throws IOException {
        this.out.writeInt(size);
    }

    public void writeOptionalNull() throws IOException {
        this.out.write(0);
    }

    public void beginOptionalValue() throws IOException {
        this.out.write(1);
    }

    public void writeUnionTag(int tag, int tagCount) throws IOException {
        Endian.putUInt(this.out, tag, tagCount - 1);
    }

    public void writeReferenceToKnownReferableRecord(int id) throws IOException {
        this.out.writeInt(id);
    }

    public void beginUnknownReferableRecord(int id) throws IOException {
        this.out.writeInt(0);
        this.out.writeInt(id);
    }
}

