/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.binary.Endian;

public class LongArraySerializer
extends Serializer.NonRecursiveSerializer {
    Range length;
    Integer fixedLength;
    Integer fixedSize;

    public LongArraySerializer(ArrayBinding binding) {
        ArrayType arrayType = binding.type();
        this.length = arrayType.getLength();
        if (this.length != null && this.length.getLower().equals(this.length.getUpper()) && this.length.getLower().getValue() != null) {
            this.fixedLength = this.length.getLower().getValue().intValue();
            this.fixedSize = this.fixedLength * 8;
        }
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        int length;
        int n = length = this.fixedSize != null ? this.fixedLength : Endian.readInt(data);
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        if (data.length < length * 8 + 4) {
            throw new SerializationException("Malformed data. Deserialization aborted. (Wrong binding?)");
        }
        long[] array = new long[length];
        int i = 0;
        int offset = 4;
        while (i < array.length) {
            array[i] = Endian.readLong(data, offset);
            ++i;
            offset += 8;
        }
        return array;
    }

    @Override
    public void deserialize(byte[] data, Object obj) throws IOException {
        long[] array;
        int length = this.fixedLength != null ? this.fixedLength : Endian.readInt(data);
        if (length != (array = (long[])obj).length) {
            throw new SerializationException("primitive array is size immutable");
        }
        if (data.length < length * 8 + 4) {
            throw new SerializationException("Malformed data. Deserialization aborted. (Wrong binding?)");
        }
        int i = 0;
        int offset = 4;
        while (i < array.length) {
            array[i] = Endian.readLong(data, offset);
            ++i;
            offset += 8;
        }
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        int length;
        int n = length = this.fixedSize != null ? this.fixedLength.intValue() : in.readInt();
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        this.assertRemainingBytes(in, (long)length * 8L);
        long[] array = new long[length];
        int i = 0;
        while (i < array.length) {
            array[i] = in.readLong();
            ++i;
        }
        return array;
    }

    @Override
    public Object deserializeToTry(DataInput in, List<Object> identities, Object obj) throws IOException {
        long[] array;
        int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length != (array = (long[])obj).length) {
            array = new long[length];
        }
        this.assertRemainingBytes(in, (long)length * 8L);
        int i = 0;
        while (i < array.length) {
            array[i] = in.readLong();
            ++i;
        }
        return array;
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        try {
            int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
            long[] array = (long[])obj;
            if (length != array.length) {
                throw new BindingException("primitive array is size immutable");
            }
            this.assertRemainingBytes(in, (long)length * 8L);
            int i = 0;
            while (i < array.length) {
                array[i] = in.readLong();
                ++i;
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in) throws IOException {
        int length = this.fixedSize != null ? this.fixedLength.intValue() : in.readInt();
        in.skipBytes(8 * length);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        long[] array = (long[])obj;
        if (this.fixedSize == null) {
            out.writeInt(array.length);
        }
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long f = lArray[n2];
            out.writeLong(f);
            ++n2;
        }
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj) {
        if (this.fixedSize != null) {
            return this.fixedSize;
        }
        long[] array = (long[])obj;
        return 4 + 8 * array.length;
    }

    @Override
    public int getMinSize() {
        return this.fixedSize != null ? this.fixedSize : 4;
    }
}

