/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.parser.unparsing;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.set.hash.THashSet;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;

public class DataTypePrinter2 {
    StringBuilder sb;
    int indentation = 0;
    THashMap<Datatype, String> refs = new THashMap();
    boolean useRef = true;
    Datatype.Visitor<Object> printVisitor = new Datatype.Visitor<Object>(){

        @Override
        public Object visit(ArrayType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Array(");
            b.componentType.accept(DataTypePrinter2.this.printVisitor);
            DataTypePrinter2.this.sb.append(")");
            return null;
        }

        @Override
        public Object visit(BooleanType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Boolean");
            return null;
        }

        @Override
        public Object visit(DoubleType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Double");
            return null;
        }

        @Override
        public Object visit(FloatType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Float");
            return null;
        }

        @Override
        public Object visit(IntegerType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Integer");
            return null;
        }

        @Override
        public Object visit(ByteType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Byte");
            return null;
        }

        @Override
        public Object visit(LongType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Long");
            return null;
        }

        @Override
        public Object visit(OptionalType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Optional(");
            b.componentType.accept(DataTypePrinter2.this.printVisitor);
            DataTypePrinter2.this.sb.append(")");
            return null;
        }

        @Override
        public Object visit(RecordType b) {
            if (DataTypePrinter2.this.refs.containsKey((Object)b) && DataTypePrinter2.this.useRef) {
                DataTypePrinter2.this.sb.append((String)DataTypePrinter2.this.refs.get((Object)b));
            } else {
                DataTypePrinter2.this.useRef = true;
                DataTypePrinter2.this.sb.append("{");
                ++DataTypePrinter2.this.indentation;
                int i = 0;
                while (i < b.getComponentCount()) {
                    if (i > 0) {
                        DataTypePrinter2.this.sb.append(", ");
                    }
                    Component c = b.getComponent(i);
                    DataTypePrinter2.this.newLine();
                    DataTypePrinter2.this.sb.append(c.name);
                    DataTypePrinter2.this.sb.append(" : ");
                    c.type.accept(DataTypePrinter2.this.printVisitor);
                    ++i;
                }
                --DataTypePrinter2.this.indentation;
                DataTypePrinter2.this.newLine();
                DataTypePrinter2.this.sb.append("}");
            }
            return null;
        }

        @Override
        public Object visit(StringType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("String");
            return null;
        }

        @Override
        public Object visit(UnionType b) {
            if (DataTypePrinter2.this.refs.containsKey((Object)b) && DataTypePrinter2.this.useRef) {
                DataTypePrinter2.this.sb.append((String)DataTypePrinter2.this.refs.get((Object)b));
            } else {
                DataTypePrinter2.this.useRef = true;
                ++DataTypePrinter2.this.indentation;
                int i = 0;
                while (i < b.getComponentCount()) {
                    DataTypePrinter2.this.newLine();
                    DataTypePrinter2.this.sb.append("| ");
                    Component c = b.getComponent(i);
                    DataTypePrinter2.this.sb.append(c.name);
                    DataTypePrinter2.this.sb.append(" ");
                    c.type.accept(DataTypePrinter2.this.printVisitor);
                    ++i;
                }
                --DataTypePrinter2.this.indentation;
            }
            return null;
        }

        @Override
        public Object visit(VariantType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Variant");
            return null;
        }

        @Override
        public Object visit(MapType b) {
            DataTypePrinter2.this.useRef = true;
            DataTypePrinter2.this.sb.append("Map(");
            b.keyType.accept(DataTypePrinter2.this.printVisitor);
            DataTypePrinter2.this.sb.append(", ");
            b.valueType.accept(DataTypePrinter2.this.printVisitor);
            DataTypePrinter2.this.sb.append(")");
            return null;
        }
    };
    THashSet<Datatype> seen = new THashSet();
    Datatype.Visitor<Object> refCollectVisitor = new Datatype.Visitor<Object>(){

        @Override
        public Object visit(ArrayType b) {
            DataTypePrinter2.this.collectRefs(b.componentType);
            return null;
        }

        @Override
        public Object visit(BooleanType b) {
            return null;
        }

        @Override
        public Object visit(DoubleType b) {
            return null;
        }

        @Override
        public Object visit(FloatType b) {
            return null;
        }

        @Override
        public Object visit(IntegerType b) {
            return null;
        }

        @Override
        public Object visit(ByteType b) {
            return null;
        }

        @Override
        public Object visit(LongType b) {
            return null;
        }

        @Override
        public Object visit(OptionalType b) {
            DataTypePrinter2.this.collectRefs(b.componentType);
            return null;
        }

        @Override
        public Object visit(RecordType b) {
            Component[] componentArray = b.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                DataTypePrinter2.this.collectRefs(c.type);
                ++n2;
            }
            return null;
        }

        @Override
        public Object visit(StringType b) {
            return null;
        }

        @Override
        public Object visit(UnionType b) {
            Component[] componentArray = b.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                DataTypePrinter2.this.collectRefs(c.type);
                ++n2;
            }
            return null;
        }

        @Override
        public Object visit(VariantType b) {
            return null;
        }

        @Override
        public Object visit(MapType b) {
            DataTypePrinter2.this.collectRefs(b.keyType);
            DataTypePrinter2.this.collectRefs(b.valueType);
            return null;
        }
    };

    private DataTypePrinter2(StringBuilder sb) {
        this.sb = sb;
    }

    void newLine() {
        this.sb.append('\n');
        int i = 0;
        while (i < this.indentation) {
            this.sb.append("    ");
            ++i;
        }
    }

    private void collectRefs(Datatype dt) {
        if ((dt instanceof RecordType || dt instanceof UnionType) && !this.seen.add((Object)dt)) {
            if (!this.refs.containsKey((Object)dt)) {
                this.refs.put((Object)dt, (Object)("T" + this.refs.size()));
            }
            return;
        }
        dt.accept(this.refCollectVisitor);
    }

    void printDt(Datatype dt) {
        this.collectRefs(dt);
        dt.accept(this.printVisitor);
        if (!this.refs.isEmpty()) {
            this.newLine();
            this.sb.append("where");
            ++this.indentation;
            this.refs.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<Datatype, String>(){

                public boolean execute(Datatype a, String b) {
                    DataTypePrinter2.this.newLine();
                    DataTypePrinter2.this.sb.append(b).append(" = ");
                    DataTypePrinter2.this.useRef = false;
                    a.accept(DataTypePrinter2.this.printVisitor);
                    return true;
                }
            });
            --this.indentation;
            this.refs.clear();
        }
    }

    public static String print(Datatype dt) {
        StringBuilder sb = new StringBuilder();
        new DataTypePrinter2(sb).printDt(dt);
        return sb.toString();
    }
}

