/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.method;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.simantics.databoard.Methods;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.method.Handshake;
import org.simantics.databoard.method.Interface;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.MethodNotSupportedException;
import org.simantics.databoard.method.MethodTypeBinding;
import org.simantics.databoard.method.MethodTypeDefinition;
import org.simantics.databoard.method.TcpConnection;
import org.simantics.databoard.serialization.SerializationException;

public class Client
implements MethodInterface {
    Socket s;
    TcpConnection c;

    public Client(String addr, int port) throws IOException, SerializationException, BindingException {
        this(InetAddress.getByName(addr), port);
    }

    public Client(InetSocketAddress sa) throws IOException, SerializationException, BindingException {
        this.s = new Socket(sa.getAddress(), sa.getPort());
        Handshake local = new Handshake();
        local.methods = Methods.noMethods().getInterface().getMethodDefinitions();
        Handshake remote = TcpConnection.handshake(this.s, local);
        this.c = new TcpConnection(this.s, Methods.noMethods(), local, remote);
    }

    public Client(InetAddress addr, int port) throws IOException, SerializationException, BindingException {
        this.s = new Socket(addr, port);
        Handshake local = new Handshake();
        local.methods = Methods.noMethods().getInterface().getMethodDefinitions();
        Handshake remote = TcpConnection.handshake(this.s, local);
        this.c = new TcpConnection(this.s, Methods.noMethods(), local, remote);
    }

    public Client(InetAddress addr, int port, MethodInterface localMethodHandler) throws IOException, SerializationException, BindingException {
        this.s = new Socket(addr, port);
        Handshake local = new Handshake();
        local.methods = localMethodHandler.getInterface().getMethodDefinitions();
        Handshake remote = TcpConnection.handshake(this.s, local);
        this.c = new TcpConnection(this.s, localMethodHandler, local, remote);
    }

    public void setConnectListener(TcpConnection.ConnectionListener listener) {
        this.c.addConnectionListener(listener);
    }

    @Override
    public Interface getInterface() {
        return this.c.getInterface();
    }

    @Override
    public MethodInterface.Method getMethod(MethodTypeBinding binding) throws MethodNotSupportedException {
        return this.c.getMethod(binding);
    }

    @Override
    public MethodInterface.Method getMethod(MethodTypeDefinition description) throws MethodNotSupportedException {
        return this.c.getMethod(description);
    }

    public TcpConnection getConnection() {
        return this.c;
    }

    public void close() {
        this.c.close();
        try {
            this.s.close();
        }
        catch (IOException iOException) {}
    }
}

