/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.method;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.method.InvokeException;
import org.simantics.databoard.method.MethodInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResultImpl
implements MethodInterface.AsyncResult {
    static Logger LOGGER = LoggerFactory.getLogger(AsyncResultImpl.class);
    InvokeException invokeException;
    Object executionError;
    Object response;
    MethodInterface.InvokeListener listener;
    Adapter responseAdapter;
    Adapter errorAdapter;
    Semaphore sleeper = new Semaphore(0);

    @Override
    public Object getExecutionError() {
        return this.executionError;
    }

    @Override
    public InvokeException getInvokeException() {
        return this.invokeException;
    }

    public void setInvokeException(final InvokeException error) {
        this.invokeException = error;
        final MethodInterface.InvokeListener l = this.listener;
        this.sleeper.release(Integer.MAX_VALUE);
        if (l != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        l.onException((Exception)error.getCause());
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Unexpected runtime exception", (Throwable)e);
                    }
                }
            }.start();
        }
    }

    public void setResponse(Object response) {
        if (this.responseAdapter != null) {
            try {
                response = this.responseAdapter.adapt(response);
            }
            catch (AdaptException e) {
                this.setInvokeException(new InvokeException("Failed to adapt the respose " + String.valueOf(response), e));
                return;
            }
        }
        this.response = response;
        final MethodInterface.InvokeListener l = this.listener;
        this.sleeper.release(Integer.MAX_VALUE);
        if (l != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        l.onCompleted(AsyncResultImpl.this.response);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Unexpected runtime exception", (Throwable)e);
                    }
                }
            }.start();
        }
    }

    public void setExecutionError(Object executionError) {
        if (this.errorAdapter != null) {
            try {
                executionError = this.errorAdapter.adapt(executionError);
            }
            catch (AdaptException e) {
                this.setInvokeException(new InvokeException("Execution and Invoke failed. Failed to adapt executionError (" + String.valueOf(executionError) + ")", e));
                return;
            }
        }
        this.executionError = executionError;
        final MethodInterface.InvokeListener l = this.listener;
        this.sleeper.release(Integer.MAX_VALUE);
        if (l != null) {
            new Thread(){

                @Override
                public void run() {
                    l.onExecutionError(AsyncResultImpl.this.executionError);
                }
            }.start();
        }
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public MethodInterface.AsyncRequestStatus getStatus() {
        if (this.invokeException != null || this.executionError != null) {
            return MethodInterface.AsyncRequestStatus.Failed;
        }
        if (this.response != null) {
            return MethodInterface.AsyncRequestStatus.Succeed;
        }
        return MethodInterface.AsyncRequestStatus.Waiting;
    }

    @Override
    public void setListener(MethodInterface.InvokeListener listener) {
        if (listener != null) {
            if (this.response != null) {
                listener.onCompleted(this.response);
            }
            if (this.invokeException != null) {
                listener.onException((Exception)this.invokeException.getCause());
            }
            if (this.executionError != null) {
                listener.onExecutionError(this.executionError);
            }
        }
        this.listener = listener;
    }

    @Override
    public Object waitForResponse() throws InvokeException, MethodInterface.ExecutionError, InterruptedException {
        this.sleeper.acquire();
        if (this.response != null) {
            return this.response;
        }
        if (this.invokeException != null) {
            throw this.invokeException;
        }
        if (this.executionError != null) {
            throw new MethodInterface.ExecutionError(this.executionError);
        }
        return null;
    }

    @Override
    public Object waitForResponse(long timeout, TimeUnit unit) throws InvokeException, MethodInterface.ExecutionError, InterruptedException {
        this.sleeper.tryAcquire(timeout, unit);
        if (this.response != null) {
            return this.response;
        }
        if (this.invokeException != null) {
            throw this.invokeException;
        }
        if (this.executionError != null) {
            throw new MethodInterface.ExecutionError(this.executionError);
        }
        return null;
    }

    public void setResponseAdapter(Adapter responseAdapter) {
        this.responseAdapter = responseAdapter;
    }

    public void setErrorAdapter(Adapter errorAdapter) {
        this.errorAdapter = errorAdapter;
    }
}

