/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.factory.BindingScheme;
import org.simantics.databoard.binding.factory.MutableBindingFactory;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class RandomValue
implements Binding.Visitor<Object> {
    public boolean refereableRecords = true;
    public Random random;
    Map<Binding, Object> map = new WeakHashMap<Binding, Object>(1);
    BindingScheme scheme = new MutableBindingFactory(new HashMap<Datatype, Binding>());
    static String CHARS = "abcdefghijklmnopqrstuvwxyz ,.-'/-+ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!\"#\ufffd%&/()=\n\\\\r'";

    public RandomValue() {
        this.random = new Random();
    }

    public RandomValue(Random random) {
        this.random = random;
    }

    public RandomValue(int seed) {
        this.random = new Random(seed);
    }

    public Random getRandom() {
        return this.random;
    }

    @Override
    public Object visit(ArrayBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        ArrayType at = b.type();
        long min = at.minLength();
        long max = Math.max(min, (long)Math.min(32, at.maxLength()));
        int c = (int)(min + this.nextRandom(max - min + 1L));
        Binding componentBinding = b.getComponentBinding();
        Object[] array = new Object[c];
        int i = 0;
        while (i < array.length) {
            array[i] = componentBinding.accept(this);
            ++i;
        }
        result = b.createUnchecked(array);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(BooleanBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        result = b.createUnchecked(this.random.nextBoolean());
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(DoubleBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        DoubleType type = b.type();
        Range range = type.getRange();
        double min = type.minValue();
        double max = type.maxValue();
        double value = range == null ? this.random.nextDouble() : min + this.random.nextDouble() * (max - min);
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(FloatBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        FloatType type = b.type();
        Range range = type.getRange();
        double min = type.minValue();
        double max = type.maxValue();
        double value = range == null ? this.random.nextDouble() : min + this.random.nextDouble() * (max - min);
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(IntegerBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        IntegerType type = b.type();
        Range range = type.getRange();
        long min = type.minValue();
        long max = type.maxValue();
        long value = range == null ? (long)this.random.nextInt() : min + Math.abs(this.random.nextLong() % (max - min));
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(ByteBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        ByteType type = b.type();
        Range range = type.getRange();
        byte min = type.minValue();
        byte max = type.maxValue();
        int value = range == null ? this.random.nextInt(256) - 128 : min + this.random.nextInt(max - min + 1);
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(LongBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        LongType type = b.type();
        Range range = type.getRange();
        long min = type.minValue();
        long max = type.maxValue();
        long value = range == null ? this.random.nextLong() : min + Math.abs(this.random.nextLong() % (max - min));
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(OptionalBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        Binding componentBinding = b.getComponentBinding();
        result = this.random.nextBoolean() ? b.createNoValueUnchecked() : b.createValueUnchecked(componentBinding.accept(this));
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(RecordBinding b) {
        try {
            Object result;
            Object object = result = this.pickCached() ? this.map.get(b) : null;
            if (result != null) {
                return result;
            }
            Object[] values = new Object[b.getComponentCount()];
            if (b.type().isReferable()) {
                result = b.createPartial();
                this.map.put(b, result);
                int i = 0;
                while (i < values.length) {
                    Binding cb = b.getComponentBinding(i);
                    values[i] = cb.accept(this);
                    ++i;
                }
                b.setComponents(result, values);
            } else {
                int i = 0;
                while (i < values.length) {
                    Binding cb = b.getComponentBinding(i);
                    values[i] = cb.accept(this);
                    ++i;
                }
                result = b.create(values);
                this.map.put(b, result);
            }
            return result;
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public Object visit(StringBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        StringType st = b.type();
        int min = st.minLength();
        int max = Math.max(min, Math.min(64, st.maxLength()));
        int c = (int)((long)min + this.nextRandom(max - min + 1));
        StringBuilder sb = new StringBuilder(c);
        int i = 0;
        while (i < c) {
            sb.append(CHARS.charAt(this.random.nextInt(CHARS.length())));
            ++i;
        }
        result = b.createUnchecked(sb.toString());
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(UnionBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        UnionType ut = b.type();
        int tag = this.random.nextInt(ut.getComponentCount());
        Binding componentBinding = b.getComponentBinding(tag);
        Object randomValue = componentBinding.accept(this);
        result = b.createUnchecked(tag, randomValue);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(VariantBinding b) {
        try {
            Object result;
            Object object = result = this.pickCached() ? this.map.get(b) : null;
            if (result != null) {
                return result;
            }
            int maxDepth = this.random.nextInt(3) + 1;
            Datatype randomType = this.randomType(0, maxDepth);
            Binding randomBinding = this.scheme.getBinding(randomType);
            Object randomValue = randomBinding.accept(this);
            result = b.createUnchecked(randomBinding, randomValue);
            this.map.put(b, result);
            return result;
        }
        catch (BindingConstructionException e) {
            throw new RuntimeBindingConstructionException(e);
        }
    }

    boolean isKeyShortEnough(Binding binding, Object value) {
        try {
            String key = (String)Bindings.adapt(value, binding, Bindings.STR_VARIANT);
            return key.length() <= 200;
        }
        catch (AdaptException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object visit(MapBinding b) {
        Object result;
        Object object = result = this.pickCached() ? this.map.get(b) : null;
        if (result != null) {
            return result;
        }
        int c = this.random.nextInt(32);
        Binding keyBinding = b.getKeyBinding();
        Binding valueBinding = b.getValueBinding();
        Object[] keys = new Object[c];
        Object[] values = new Object[c];
        int i = 0;
        while (i < c) {
            Object key = null;
            if (keyBinding.type().equals(Datatypes.VARIANT)) {
                do {
                    key = keyBinding.accept(this);
                } while (!keyBinding.type().equals(Datatypes.VARIANT) || !this.isKeyShortEnough(keyBinding, key));
            } else {
                key = keyBinding.accept(this);
            }
            keys[i] = key;
            values[i] = valueBinding.accept(this);
            ++i;
        }
        result = b.createUnchecked(keys, values);
        this.map.put(b, result);
        return result;
    }

    public Datatype randomType(int depth, int maxDepth) {
        int tag = 0;
        if (depth < maxDepth) {
            tag = this.random.nextInt(12);
            if (this.random.nextInt(500) == 0) {
                tag = 12;
            }
        } else {
            tag = this.random.nextInt(7);
        }
        if (tag == 0) {
            return new BooleanType();
        }
        if (tag == 1) {
            Limit lowerLimit = Limit.exclusive((this.random.nextInt() & 0xFF) - 128);
            Limit upperLimit = Limit.exclusive((this.random.nextInt() & 0xFF) - 128);
            Range range = this.random.nextBoolean() ? Range.between(lowerLimit, upperLimit) : null;
            ByteType result = new ByteType(null, range);
            if (result.minValue() > result.maxValue()) {
                result.setRange((Range)null);
            }
            return result;
        }
        if (tag == 2) {
            Limit lowerLimit = Limit.inclusive(0);
            Limit upperLimit = Limit.exclusive(this.random.nextInt());
            Range range = this.random.nextBoolean() ? Range.between(lowerLimit, upperLimit) : null;
            IntegerType result = new IntegerType(null, range);
            if (result.minValue() > result.maxValue()) {
                result.setRange((Range)null);
            }
            return result;
        }
        if (tag == 3) {
            Limit lowerLimit = Limit.inclusive(0);
            Limit upperLimit = Limit.exclusive(this.random.nextLong());
            Range range = this.random.nextBoolean() ? Range.between(lowerLimit, upperLimit) : null;
            LongType result = new LongType(null, range);
            if (result.minValue() > result.maxValue()) {
                result.setRange((Range)null);
            }
            return result;
        }
        if (tag == 4) {
            Limit lowerLimit = Limit.inclusive(0);
            Limit upperLimit = Limit.exclusive(this.random.nextDouble() * (double)this.random.nextInt());
            Range range = this.random.nextBoolean() ? Range.between(lowerLimit, upperLimit) : null;
            FloatType result = new FloatType(null, range);
            if (result.minValue() > result.maxValue()) {
                result.setRange((Range)null);
            }
            return result;
        }
        if (tag == 5) {
            Limit lowerLimit = Limit.inclusive(0);
            Limit upperLimit = Limit.exclusive(this.random.nextDouble() * (double)this.random.nextInt());
            Range range = this.random.nextBoolean() ? Range.between(lowerLimit, upperLimit) : null;
            DoubleType result = new DoubleType(null, range);
            if (result.minValue() > result.maxValue()) {
                result.setRange((Range)null);
            }
            return result;
        }
        if (tag == 6) {
            Limit lowerLimit = Limit.inclusive(0);
            Limit upperLimit = Limit.exclusive(this.random.nextInt(1024));
            Range range = this.random.nextBoolean() ? Range.between(lowerLimit, upperLimit) : null;
            StringType result = new StringType(null, null, range);
            if (result.minLength() > result.maxLength()) {
                result.setLength((Range)null);
            }
            return result;
        }
        if (tag == 7) {
            int c = this.random.nextInt(16);
            Component[] components = new Component[c];
            String[] names = this.randomUniqueNames(c);
            int i = 0;
            while (i < c) {
                components[i] = new Component(names[i], this.randomType(depth + 1, maxDepth));
                ++i;
            }
            return new RecordType(this.refereableRecords ? this.random.nextBoolean() : false, components);
        }
        if (tag == 8) {
            Limit lowerLimit = Limit.inclusive(this.random.nextInt(16));
            Limit upperLimit = Limit.exclusive(this.random.nextInt(16));
            Range range = this.random.nextBoolean() ? Range.between(lowerLimit, upperLimit) : null;
            ArrayType result = new ArrayType(this.randomType(depth + 1, maxDepth), range);
            if (result.minLength() > result.maxLength()) {
                result.setLength((Range)null);
            }
            return result;
        }
        if (tag == 9) {
            return new MapType(this.randomType(depth + 1, maxDepth), this.randomType(depth + 1, maxDepth));
        }
        if (tag == 10) {
            return new OptionalType(this.randomType(depth + 1, maxDepth));
        }
        if (tag == 11) {
            int c = this.random.nextInt(16) + 1;
            Component[] components = new Component[c];
            String[] names = this.randomUniqueNames(c);
            int i = 0;
            while (i < c) {
                components[i] = new Component(names[i], this.randomType(depth + 1, maxDepth));
                ++i;
            }
            return new UnionType(components);
        }
        if (tag == 12) {
            return new VariantType();
        }
        return null;
    }

    boolean pickCached() {
        if (!this.refereableRecords) {
            return false;
        }
        return this.refereableRecords && this.random.nextInt(10) == 0;
    }

    String randomName() {
        int nameLength = this.random.nextInt(32) + 1;
        StringBuilder sb = new StringBuilder(nameLength);
        int j = 0;
        while (j < nameLength) {
            sb.append(CHARS.charAt(this.random.nextInt(CHARS.length())));
            ++j;
        }
        return sb.toString();
    }

    String[] randomUniqueNames(int count) {
        HashSet<String> result = new HashSet<String>(count);
        int i = 0;
        while (i < count) {
            String name = null;
            while (result.contains(name = this.randomName())) {
            }
            result.add(name);
            ++i;
        }
        return result.toArray(new String[count]);
    }

    long nextRandom(long n) {
        long v = this.random.nextLong();
        v = Math.abs(v);
        return v % n;
    }
}

