/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.util;

import java.util.Map;
import java.util.WeakHashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.Range;

public class DefaultValue
implements Binding.Visitor<Object> {
    Map<Binding, Object> map = new WeakHashMap<Binding, Object>(1);

    @Override
    public Object visit(ArrayBinding b) {
        int min;
        Object result = null;
        ArrayType at = b.type();
        Range r = at.getLength();
        int n = min = r != null ? r.getLower().getValue().intValue() : 0;
        if (min > 0) {
            Binding componentBinding = b.getComponentBinding();
            Object[] array = new Object[min];
            int i = 0;
            while (i < min) {
                array[i] = componentBinding.accept(this);
                ++i;
            }
            result = b.createUnchecked(array);
        } else {
            result = b.createUnchecked(new Object[0]);
        }
        return result;
    }

    @Override
    public Object visit(BooleanBinding b) {
        Object result = b.createUnchecked(Boolean.FALSE);
        return result;
    }

    @Override
    public Object visit(DoubleBinding b) {
        DoubleType type = b.type();
        Range range = type.getRange();
        Number lowValue = range == null ? (Number)null : (Number)range.getLower().getValue();
        return b.createUnchecked(lowValue == null ? 0.0 : lowValue.doubleValue());
    }

    @Override
    public Object visit(FloatBinding b) {
        FloatType type = b.type();
        Range range = type.getRange();
        Number lowValue = range == null ? (Number)null : (Number)range.getLower().getValue();
        return b.createUnchecked(lowValue == null ? 0.0f : lowValue.floatValue());
    }

    @Override
    public Object visit(IntegerBinding b) {
        IntegerType type = b.type();
        Range range = type.getRange();
        Number lowValue = range == null ? (Number)null : (Number)range.getLower().getValue();
        return b.createUnchecked(lowValue == null ? 0 : lowValue.intValue());
    }

    @Override
    public Object visit(ByteBinding b) {
        ByteType type = b.type();
        Range range = type.getRange();
        Number lowValue = range == null ? (Number)null : (Number)range.getLower().getValue();
        return b.createUnchecked(lowValue == null ? 0 : lowValue.intValue());
    }

    @Override
    public Object visit(LongBinding b) {
        LongType type = b.type();
        Range range = type.getRange();
        Number lowValue = range == null ? (Number)null : (Number)range.getLower().getValue();
        return b.createUnchecked(lowValue == null ? 0L : lowValue.longValue());
    }

    @Override
    public Object visit(OptionalBinding b) {
        return b.createNoValueUnchecked();
    }

    @Override
    public Object visit(RecordBinding b) {
        try {
            Object result = null;
            if (b.type().isReferable() && (result = this.map.get(b)) != null) {
                return result;
            }
            Object[] values = new Object[b.getComponentCount()];
            result = b.createPartial();
            if (b.type().isReferable()) {
                this.map.put(b, result);
            }
            int i = 0;
            while (i < values.length) {
                Binding cb = b.getComponentBinding(i);
                values[i] = cb.accept(this);
                ++i;
            }
            b.setComponents(result, values);
            return result;
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public Object visit(StringBinding b) {
        Object result = null;
        StringType st = b.type();
        result = st.getPattern() != null ? b.createUnchecked("") : b.createUnchecked("");
        return result;
    }

    @Override
    public Object visit(UnionBinding b) {
        int tag = 0;
        Binding componentBinding = b.getComponentBinding(tag);
        Object tag0defaultValue = componentBinding.accept(this);
        return b.createUnchecked(tag, tag0defaultValue);
    }

    @Override
    public Object visit(VariantBinding b) {
        Object voidBinding = Bindings.getBindingUnchecked(Void.TYPE);
        Object voidValue = null;
        return b.createUnchecked((Binding)voidBinding, voidValue);
    }

    @Override
    public Object visit(MapBinding b) {
        return b.createUnchecked();
    }
}

