/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;

public class ClassInfo {
    public Constructor<?> argsConstructor;
    public Constructor<?> noArgsConstructor;
    public Constructor<?> beanConstructor;
    public Class<?> clazz;
    public Field[] fields;
    public Method[] getters;
    public Method[] setters;
    public boolean[] writable;
    public boolean partialConstructionPossible;

    public static ClassInfo getInfo(Class<?> clazz) throws BindingConstructionException {
        boolean isAbstract = (clazz.getModifiers() & 0x400) != 0;
        ClassInfo ci = new ClassInfo();
        ci.clazz = clazz;
        try {
            Field[] fieldArray = ci.fields = ClassInfo.getFields(clazz);
            int n = ci.fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                f.setAccessible(true);
                ++n2;
            }
            int c = ci.fields.length;
            ci.getters = new Method[c];
            ci.setters = new Method[c];
            ci.writable = new boolean[c];
            int i = 0;
            while (i < ci.fields.length) {
                Field f = ci.fields[i];
                boolean isPublic = (f.getModifiers() & 1) > 0;
                boolean isFinal = (f.getModifiers() & 0x10) > 0;
                boolean isPrimitive = f.getType().getName().length() == 49;
                ci.writable[i] = isPublic && (!isFinal || isPrimitive);
                String name = f.getName();
                try {
                    String getterName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
                    Method getter = clazz.getMethod(getterName, new Class[0]);
                    if (getter.getReturnType().equals(f.getType())) {
                        ci.getters[i] = getter;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                try {
                    String setterName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
                    Method setter = clazz.getMethod(setterName, f.getType());
                    if (setter.getReturnType().equals(Void.TYPE)) {
                        ci.setters[i] = setter;
                        ci.writable[i] = true;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                ++i;
            }
            if (!isAbstract) {
                Class[] constructorArgs = new Class[ci.fields.length];
                int i2 = 0;
                while (i2 < ci.fields.length) {
                    constructorArgs[i2] = ci.fields[i2].getType();
                    ++i2;
                }
                try {
                    ci.argsConstructor = clazz.getDeclaredConstructor(constructorArgs);
                    ci.argsConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                try {
                    ci.noArgsConstructor = clazz.getDeclaredConstructor(new Class[0]);
                    ci.noArgsConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                try {
                    ci.beanConstructor = clazz.getDeclaredConstructor(Binding.class);
                    ci.beanConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            boolean allWritable = true;
            boolean[] blArray = ci.writable;
            int n3 = ci.writable.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean b = blArray[n4];
                allWritable &= b;
                ++n4;
            }
            ci.partialConstructionPossible = allWritable;
            return ci;
        }
        catch (SecurityException e1) {
            throw new BindingConstructionException(e1);
        }
    }

    static Field[] getFields(Class<?> clazz) {
        Field[] fields = ClassInfo.getAllFields(clazz);
        ArrayList<Field> result = new ArrayList<Field>(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!(Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || Modifier.isVolatile(f.getModifiers()))) {
                f.setAccessible(true);
                result.add(f);
            }
            ++n2;
        }
        return result.toArray(new Field[result.size()]);
    }

    static Field[] getAllFields(Class<?> clazz) {
        LinkedList classes = new LinkedList();
        while (clazz != null) {
            classes.addFirst(clazz);
            clazz = clazz.getSuperclass();
            if (clazz != Throwable.class) continue;
            clazz = null;
        }
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class clazz2 : classes) {
            ClassInfo._getAllFields(clazz2, result);
        }
        return result.toArray(new Field[result.size()]);
    }

    public static void _getAllFields(Class<?> clazz, Collection<Field> result) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field m = fieldArray[n2];
            result.add(m);
            ++n2;
        }
    }

    public boolean equals(Object arg0) {
        return this == arg0 || arg0.getClass().equals(this.getClass()) && ((ClassInfo)arg0).clazz.equals(this.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }
}

