/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.DataValueUtil;
import org.simantics.databoard.util.IdentityPair;

public abstract class VariantBinding
extends Binding {
    public VariantBinding() {
        this.type = Datatypes.VARIANT;
    }

    public abstract Object getContent(Object var1, Binding var2) throws BindingException;

    public abstract Object getContent(Object var1) throws BindingException;

    public abstract Datatype getContentType(Object var1) throws BindingException;

    public abstract Binding getContentBinding(Object var1) throws BindingException;

    public abstract Object create(Binding var1, Object var2) throws BindingException;

    public Object createUnchecked(Binding contentBinding, Object content) throws RuntimeBindingException {
        try {
            return this.create(contentBinding, content);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        try {
            VariantBinding sb = (VariantBinding)srcBinding;
            Datatype newType = sb.getContentType(src);
            Datatype oldType = this.getContentType(dst);
            Binding scb = sb.getContentBinding(src);
            Object sc = sb.getContent(src, scb);
            if (newType.equals(oldType)) {
                Binding dcb = this.getContentBinding(dst);
                if (dcb.isImmutable()) {
                    Object dc = Bindings.clone(sc, scb, scb);
                    this.setContent(dst, scb, dc);
                } else {
                    Object dc = this.getContent(dst, dcb);
                    dc = dcb.readFromTry(scb, sc, dc);
                    this.setContent(dst, dcb, dc);
                }
            } else {
                Object dc = Bindings.clone(sc, scb, scb);
                this.setContent(dst, scb, dc);
            }
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    public abstract void setContent(Object var1, Binding var2, Object var3) throws BindingException;

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        Datatype type = this.getContentType(value);
        Binding binding = this.getContentBinding(value);
        Object element = this.getContent(value, binding);
        return Bindings.DATATYPE.deepHashValue(type, hashedObjects) + binding.deepHashValue(element, hashedObjects);
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        Datatype t2;
        Datatype t1 = this.getContentType(o1);
        int dif = Bindings.DATATYPE.compare(t1, t2 = this.getContentType(o2));
        if (dif != 0) {
            return dif;
        }
        Binding bi1 = this.getContentBinding(o1);
        Binding bi2 = this.getContentBinding(o2);
        Object va1 = this.getContent(o1, bi1);
        Object va2 = this.getContent(o2, bi2);
        return DataValueUtil.compare(bi1, va1, bi2, va2);
    }

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        Binding b = this.getContentBinding(value);
        b.toString(this.getContent(value), ctx);
        ctx.b.append(" : ");
        ctx.b.append(ctx.singleLine ? b.type.toSingleLineString() : b.type.toString());
    }

    @Override
    public Binding getComponentBinding(ChildReference path) {
        if (path == null) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getComponentCount() {
        return 0;
    }

    @Override
    public Binding getComponentBinding(int index) {
        throw new IllegalArgumentException();
    }
}

