/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Range;

public abstract class StringBinding
extends Binding {
    public StringBinding(StringType type) {
        this.type = type;
    }

    @Override
    public StringType type() {
        return (StringType)this.type;
    }

    public abstract Object create(String var1) throws BindingException;

    public Object createUnchecked(String value) throws RuntimeBindingException {
        try {
            return this.create(value);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        String v = ((StringBinding)srcBinding).getValue(src);
        this.setValue(dst, v);
    }

    public abstract String getValue(Object var1) throws BindingException;

    public abstract void setValue(Object var1, String var2) throws BindingException;

    @Override
    public abstract boolean isInstance(Object var1);

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        if (!this.isInstance(obj)) {
            throw new BindingException("Not a correct instance");
        }
        StringType type = this.type();
        Pattern p = type.getCompiledPattern();
        String mimeType = type.getMimeType();
        Range length = type.getLength();
        if (p == null && length == null && mimeType == null) {
            return;
        }
        String str = this.getValue(obj);
        if (p != null && !p.matcher(str).matches()) {
            throw new BindingException("The value (" + str + ") doesn't match the pattern (" + p.toString() + ").");
        }
        if (length != null && !length.contains(str.length())) {
            throw new BindingException("Length (" + str.length() + ") doesn't fit into the range " + String.valueOf(length));
        }
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        String v1 = this.getValue(o1);
        String v2 = this.getValue(o2);
        return v1.compareTo(v2);
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        return this.getValue(value).hashCode();
    }

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        ctx.b.append('\"');
        ctx.b.append(this.getValue(value));
        ctx.b.append('\"');
    }

    @Override
    public Binding getComponentBinding(ChildReference path) {
        if (path == null) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getComponentCount() {
        return 0;
    }

    @Override
    public Binding getComponentBinding(int index) {
        throw new IllegalArgumentException();
    }
}

