/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.adapter;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.simantics.databoard.Units;
import org.simantics.databoard.adapter.AbstractAdapter;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.adapter.AdapterRequest;
import org.simantics.databoard.adapter.PassThruAdapter;
import org.simantics.databoard.adapter.RuntimeAdaptException;
import org.simantics.databoard.adapter.RuntimeAdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.databoard.binding.impl.BooleanArrayBinding;
import org.simantics.databoard.binding.impl.ByteArrayBinding;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.binding.impl.FloatArrayBinding;
import org.simantics.databoard.binding.impl.IntArrayBinding;
import org.simantics.databoard.binding.impl.LongArrayBinding;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.units.IUnitConverter;
import org.simantics.databoard.units.IdentityConverter;
import org.simantics.databoard.units.internal.UnitParseException;
import org.simantics.databoard.util.ObjectUtils;

public class AdapterFactory {
    Map<AdapterRequest, AbstractAdapter> cache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.SOFT, AbstractReferenceMap.ReferenceStrength.HARD);

    public synchronized Adapter getAdapter(Binding domain, Binding range, boolean typeAdapter, boolean mustClone) throws AdapterConstructionException {
        if ((!mustClone || domain.isImmutable()) && domain.equals(range)) {
            return PassThruAdapter.PASSTHRU;
        }
        if (domain.getClass() == range.getClass() && (!mustClone || domain.isImmutable()) && NumberBinding.class.isAssignableFrom(domain.getClass())) {
            NumberBinding db = (NumberBinding)domain;
            NumberBinding rb = (NumberBinding)range;
            String u1 = db.type().getUnit();
            String u2 = rb.type().getUnit();
            if (u1 == null || u2 == null || u1.equals("") || u2.equals("") || u1.equals(u2)) {
                return PassThruAdapter.PASSTHRU;
            }
        }
        return this.getAdapterUnsynchronized(domain, range, typeAdapter, mustClone);
    }

    private AbstractAdapter getCached(AdapterRequest type) {
        return this.cache.get(type);
    }

    private void cache(AdapterRequest type, AbstractAdapter binding) {
        this.cache.put(type, binding);
    }

    private void addToCache(AdapterRequest request, AbstractAdapter impl) {
        impl.request = request;
        this.cache(request, impl);
        if (!request.mustClone && impl.clones) {
            request = new AdapterRequest(request.domain, request.range, request.typeAdapter, true);
            this.cache(request, impl);
        }
    }

    private AbstractAdapter getAdapterUnsynchronized(Binding domain, Binding range, boolean typeAdapter, final boolean mustClone) throws AdapterConstructionException {
        if (!mustClone && domain.equals(range)) {
            return PassThruAdapter.PASSTHRU;
        }
        AdapterRequest req = new AdapterRequest(domain, range, typeAdapter, mustClone);
        AbstractAdapter cachedResult = this.getCached(req);
        if (cachedResult != null) {
            return cachedResult;
        }
        try {
            if (domain instanceof RecordBinding && range instanceof RecordBinding) {
                final RecordBinding domainRecord = (RecordBinding)domain;
                final RecordBinding rangeRecord = (RecordBinding)range;
                RecordType domainType = domainRecord.type();
                RecordType rangeType = rangeRecord.type();
                boolean requiresTypeAdapting = domainType.getComponentCount() != rangeType.getComponentCount();
                int[] fieldMap = new int[rangeType.getComponentCount()];
                int rangeIndex = 0;
                while (rangeIndex < fieldMap.length) {
                    String fieldName = rangeType.getComponent((int)rangeIndex).name;
                    Integer domainIndex = domainType.getComponentIndex(fieldName);
                    if (domainIndex != null) {
                        fieldMap[rangeIndex] = domainIndex;
                        requiresTypeAdapting |= rangeIndex != domainIndex;
                    } else {
                        fieldMap[rangeIndex] = -1;
                        requiresTypeAdapting = true;
                    }
                    ++rangeIndex;
                }
                if (requiresTypeAdapting && !typeAdapter) {
                    throw new AdapterConstructionException("Type Adapter required.");
                }
                final int len = rangeRecord.componentBindings.length;
                final AbstractAdapter[] componentAdapters = new AbstractAdapter[len];
                AbstractAdapter result = null;
                if (!requiresTypeAdapting) {
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object src) throws AdaptException {
                            try {
                                Object[] values = new Object[len];
                                int i = 0;
                                while (i < len) {
                                    Object dstValue;
                                    Object srcValue = domainRecord.getComponent(src, i);
                                    values[i] = dstValue = componentAdapters[i].adapt(srcValue);
                                    ++i;
                                }
                                return rangeRecord.create(values);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                } else {
                    final int[] _fieldMap = fieldMap;
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object src) throws AdaptException {
                            try {
                                Object[] values = new Object[len];
                                int rangeIndex = 0;
                                while (rangeIndex < len) {
                                    int domainIndex = _fieldMap[rangeIndex];
                                    if (domainIndex >= 0) {
                                        Object dstValue;
                                        Object srcValue = domainRecord.getComponent(src, domainIndex);
                                        values[rangeIndex] = dstValue = componentAdapters[rangeIndex].adapt(srcValue);
                                    } else {
                                        values[rangeIndex] = rangeRecord.componentBindings[rangeIndex].createDefault();
                                    }
                                    ++rangeIndex;
                                }
                                return rangeRecord.create(values);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                    result.typeAdapter = true;
                }
                this.addToCache(req, result);
                result.clones = true;
                int rangeIndex2 = 0;
                while (rangeIndex2 < len) {
                    int domainIndex = fieldMap[rangeIndex2];
                    if (domainIndex >= 0) {
                        componentAdapters[rangeIndex2] = this.getAdapterUnsynchronized(domainRecord.componentBindings[domainIndex], rangeRecord.componentBindings[rangeIndex2], typeAdapter, mustClone);
                        result.typeAdapter |= componentAdapters[rangeIndex2].typeAdapter;
                        result.clones &= componentAdapters[rangeIndex2].clones;
                    }
                    ++rangeIndex2;
                }
                return result;
            }
            if (domain instanceof UnionBinding && range instanceof UnionBinding) {
                final UnionBinding domainBinding = (UnionBinding)domain;
                final UnionBinding rangeBinding = (UnionBinding)range;
                UnionType domainType = domainBinding.type();
                UnionType rangeType = rangeBinding.type();
                boolean requiresTypeAdapting = domainType.getComponentCount() != rangeType.getComponentCount();
                int[] tagMap = new int[domainType.getComponentCount()];
                int domainIndex = 0;
                while (domainIndex < tagMap.length) {
                    String fieldName = domainType.getComponent((int)domainIndex).name;
                    Integer rangeIndex = rangeType.getComponentIndex(fieldName);
                    if (rangeIndex == null) {
                        throw new AdapterConstructionException("The range UnionType does not have expected tag \"" + fieldName + "\"");
                    }
                    tagMap[domainIndex] = rangeIndex;
                    requiresTypeAdapting |= rangeIndex != domainIndex;
                    ++domainIndex;
                }
                if (requiresTypeAdapting && !typeAdapter) {
                    throw new AdapterConstructionException("Type Adapter required.");
                }
                final AbstractAdapter[] componentAdapters = new AbstractAdapter[domainType.getComponentCount()];
                AbstractAdapter result = null;
                if (!requiresTypeAdapting) {
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                int tag = domainBinding.getTag(obj);
                                Object srcValue = domainBinding.getValue(obj);
                                Object dstValue = componentAdapters[tag].adapt(srcValue);
                                return rangeBinding.create(tag, dstValue);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                } else {
                    final int[] _tagMap = tagMap;
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                int domainTag = domainBinding.getTag(obj);
                                int rangeTag = _tagMap[domainTag];
                                Object srcValue = domainBinding.getValue(obj);
                                Object dstValue = componentAdapters[domainTag].adapt(srcValue);
                                return rangeBinding.create(rangeTag, dstValue);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                }
                this.addToCache(req, result);
                result.clones = true;
                int domainIndex2 = 0;
                while (domainIndex2 < domainType.getComponentCount()) {
                    int rangeIndex = tagMap[domainIndex2];
                    componentAdapters[domainIndex2] = this.getAdapterUnsynchronized(domainBinding.getComponentBindings()[domainIndex2], rangeBinding.getComponentBindings()[rangeIndex], typeAdapter, mustClone);
                    result.typeAdapter |= componentAdapters[domainIndex2].typeAdapter;
                    result.clones &= componentAdapters[domainIndex2].clones;
                    ++domainIndex2;
                }
                return result;
            }
            if (domain instanceof BooleanBinding && range instanceof BooleanBinding) {
                final BooleanBinding domainBoolean = (BooleanBinding)domain;
                final BooleanBinding rangeBoolean = (BooleanBinding)range;
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            boolean value = domainBoolean.getValue_(obj);
                            return rangeBoolean.create(value);
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = mustClone;
                result.typeAdapter = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof BooleanBinding && range instanceof NumberBinding) {
                try {
                    final BooleanBinding domainBoolean = (BooleanBinding)domain;
                    NumberBinding rangeNumber = (NumberBinding)range;
                    final Object falseValue = rangeNumber.create(0);
                    final Object trueValue = rangeNumber.create(1);
                    AbstractAdapter result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                boolean value = domainBoolean.getValue_(obj);
                                return value ? trueValue : falseValue;
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                    result.clones = true;
                    result.typeAdapter = true;
                    this.addToCache(req, result);
                    return result;
                }
                catch (BindingException e1) {
                    throw new AdapterConstructionException(e1);
                }
            }
            if (domain instanceof NumberBinding && range instanceof BooleanBinding) {
                try {
                    final NumberBinding domainNumber = (NumberBinding)domain;
                    final BooleanBinding rangeBoolean = (BooleanBinding)range;
                    final Object zeroValue = domainNumber.create(0);
                    AbstractAdapter result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                Number value = domainNumber.getValue(obj);
                                boolean bool = !domainNumber.equals((Object)value, zeroValue);
                                return rangeBoolean.create(bool);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                    result.clones = true;
                    this.addToCache(req, result);
                    return result;
                }
                catch (BindingException e1) {
                    throw new AdapterConstructionException(e1);
                }
            }
            if (domain instanceof StringBinding && range instanceof StringBinding) {
                final StringBinding domainString = (StringBinding)domain;
                final StringBinding rangeString = (StringBinding)range;
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            String value = domainString.getValue(obj);
                            return rangeString.create(value);
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof StringBinding && range instanceof NumberBinding) {
                final StringBinding domainString = (StringBinding)domain;
                final NumberBinding rangeString = (NumberBinding)range;
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            String value = domainString.getValue(obj);
                            return rangeString.create(value);
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof StringBinding && range instanceof BooleanBinding) {
                final StringBinding domainString = (StringBinding)domain;
                final BooleanBinding rangeString = (BooleanBinding)range;
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            String value = domainString.getValue(obj);
                            return rangeString.create(Boolean.parseBoolean(value));
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof NumberBinding && range instanceof NumberBinding) {
                AbstractAdapter result;
                boolean doPrimitiveConversion;
                final NumberBinding domainNumber = (NumberBinding)domain;
                final NumberBinding rangeNumber = (NumberBinding)range;
                String domainUnit = domainNumber.type().getUnit();
                String rangeUnit = rangeNumber.type().getUnit();
                IUnitConverter unitConverter = domainUnit == null || rangeUnit == null || domainUnit.equals(rangeUnit) ? null : Units.createConverter(domainUnit, rangeUnit);
                boolean doUnitConversion = unitConverter != null && unitConverter != IdentityConverter.INSTANCE;
                boolean bl = doPrimitiveConversion = !domainNumber.type().getClass().equals(rangeNumber.type().getClass());
                if (doPrimitiveConversion && !typeAdapter) {
                    throw new AdapterConstructionException("Type mismatch, use Type Adapter instead.");
                }
                if (!doUnitConversion) {
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                Number value = domainNumber.getValue(obj);
                                return rangeNumber.create(value);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                } else {
                    final IUnitConverter _unitConverter = unitConverter;
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                Number value = domainNumber.getValue(obj);
                                double convertedValue = _unitConverter.convert(value.doubleValue());
                                return rangeNumber.create(convertedValue);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                }
                result.typeAdapter = doPrimitiveConversion;
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof BooleanArrayBinding && range instanceof BooleanArrayBinding) {
                final BooleanArrayBinding domainArray = (BooleanArrayBinding)domain;
                final BooleanArrayBinding rangeArray = (BooleanArrayBinding)range;
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            boolean[] data = domainArray.getArray(obj);
                            if (mustClone) {
                                data = (boolean[])data.clone();
                            }
                            return rangeArray.create(data);
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof ByteArrayBinding && range instanceof ByteArrayBinding) {
                AbstractAdapter result;
                boolean doUnitConversion;
                String rangeUnit;
                final ByteArrayBinding domainArray = (ByteArrayBinding)domain;
                final ByteArrayBinding rangeArray = (ByteArrayBinding)range;
                String domainUnit = ((NumberType)domainArray.type().componentType).getUnit();
                IUnitConverter unitConverter = ObjectUtils.objectEquals(domainUnit, rangeUnit = ((NumberType)rangeArray.type().componentType).getUnit()) ? null : Units.createConverter(domainUnit, rangeUnit);
                boolean bl = doUnitConversion = unitConverter != null && unitConverter != IdentityConverter.INSTANCE;
                if (doUnitConversion) {
                    final IUnitConverter _unitConverter = unitConverter;
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                byte[] data = domainArray.getArray(obj);
                                int i = 0;
                                while (i < data.length) {
                                    byte value = data[i];
                                    double convertedValue = _unitConverter.convert(value);
                                    data[i] = (byte)convertedValue;
                                    ++i;
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                } else {
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                byte[] data = domainArray.getArray(obj);
                                if (mustClone) {
                                    data = (byte[])data.clone();
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                }
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof IntArrayBinding && range instanceof IntArrayBinding) {
                AbstractAdapter result;
                boolean doUnitConversion;
                String rangeUnit;
                final IntArrayBinding domainArray = (IntArrayBinding)domain;
                final IntArrayBinding rangeArray = (IntArrayBinding)range;
                String domainUnit = ((NumberType)domainArray.type().componentType).getUnit();
                IUnitConverter unitConverter = ObjectUtils.objectEquals(domainUnit, rangeUnit = ((NumberType)rangeArray.type().componentType).getUnit()) || domainUnit == null || rangeUnit == null ? null : Units.createConverter(domainUnit, rangeUnit);
                boolean bl = doUnitConversion = unitConverter != null && unitConverter != IdentityConverter.INSTANCE;
                if (doUnitConversion) {
                    final IUnitConverter _unitConverter = unitConverter;
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                int[] data = domainArray.getArray(obj);
                                int i = 0;
                                while (i < data.length) {
                                    int value = data[i];
                                    double convertedValue = _unitConverter.convert(value);
                                    data[i] = (int)convertedValue;
                                    ++i;
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                } else {
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                int[] data = domainArray.getArray(obj);
                                if (mustClone) {
                                    data = (int[])data.clone();
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                }
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof LongArrayBinding && range instanceof LongArrayBinding) {
                AbstractAdapter result;
                boolean doUnitConversion;
                String rangeUnit;
                final LongArrayBinding domainArray = (LongArrayBinding)domain;
                final LongArrayBinding rangeArray = (LongArrayBinding)range;
                String domainUnit = ((NumberType)domainArray.type().componentType).getUnit();
                IUnitConverter unitConverter = ObjectUtils.objectEquals(domainUnit, rangeUnit = ((NumberType)rangeArray.type().componentType).getUnit()) || domainUnit == null || rangeUnit == null ? null : Units.createConverter(domainUnit, rangeUnit);
                boolean bl = doUnitConversion = unitConverter != null && unitConverter != IdentityConverter.INSTANCE;
                if (doUnitConversion) {
                    final IUnitConverter _unitConverter = unitConverter;
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                long[] data = domainArray.getArray(obj);
                                int i = 0;
                                while (i < data.length) {
                                    long value = data[i];
                                    double convertedValue = _unitConverter.convert(value);
                                    data[i] = (long)convertedValue;
                                    ++i;
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                } else {
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                long[] data = domainArray.getArray(obj);
                                if (mustClone) {
                                    data = (long[])data.clone();
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                }
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof FloatArrayBinding && range instanceof FloatArrayBinding) {
                AbstractAdapter result;
                boolean doUnitConversion;
                String rangeUnit;
                final FloatArrayBinding domainArray = (FloatArrayBinding)domain;
                final FloatArrayBinding rangeArray = (FloatArrayBinding)range;
                String domainUnit = ((NumberType)domainArray.type().componentType).getUnit();
                IUnitConverter unitConverter = ObjectUtils.objectEquals(domainUnit, rangeUnit = ((NumberType)rangeArray.type().componentType).getUnit()) || domainUnit == null || rangeUnit == null ? null : Units.createConverter(domainUnit, rangeUnit);
                boolean bl = doUnitConversion = unitConverter != null && unitConverter != IdentityConverter.INSTANCE;
                if (doUnitConversion) {
                    final IUnitConverter _unitConverter = unitConverter;
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                float[] data = domainArray.getArray(obj);
                                int i = 0;
                                while (i < data.length) {
                                    float value = data[i];
                                    double convertedValue = _unitConverter.convert(value);
                                    data[i] = (float)convertedValue;
                                    ++i;
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                } else {
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                float[] data = domainArray.getArray(obj);
                                if (mustClone) {
                                    data = (float[])data.clone();
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                }
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof DoubleArrayBinding && range instanceof DoubleArrayBinding) {
                AbstractAdapter result;
                boolean doUnitConversion;
                String rangeUnit;
                final DoubleArrayBinding domainArray = (DoubleArrayBinding)domain;
                final DoubleArrayBinding rangeArray = (DoubleArrayBinding)range;
                String domainUnit = ((NumberType)domainArray.type().componentType).getUnit();
                IUnitConverter unitConverter = ObjectUtils.objectEquals(domainUnit, rangeUnit = ((NumberType)rangeArray.type().componentType).getUnit()) || domainUnit == null || rangeUnit == null ? null : Units.createConverter(domainUnit, rangeUnit);
                boolean bl = doUnitConversion = unitConverter != null && unitConverter != IdentityConverter.INSTANCE;
                if (doUnitConversion) {
                    final IUnitConverter _unitConverter = unitConverter;
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                double[] data = domainArray.getArray(obj);
                                int i = 0;
                                while (i < data.length) {
                                    double convertedValue;
                                    double value = data[i];
                                    data[i] = convertedValue = _unitConverter.convert(value);
                                    ++i;
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                } else {
                    result = new AbstractAdapter(){

                        @Override
                        public Object adapt(Object obj) throws AdaptException {
                            try {
                                double[] data = domainArray.getArray(obj);
                                if (mustClone) {
                                    data = (double[])data.clone();
                                }
                                return rangeArray.create(data);
                            }
                            catch (BindingException e) {
                                throw new AdaptException(e);
                            }
                        }
                    };
                }
                result.clones = true;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof ArrayBinding && range instanceof ArrayBinding) {
                final ArrayBinding domainBinding = (ArrayBinding)domain;
                final ArrayBinding rangeBinding = (ArrayBinding)range;
                final AbstractAdapter componentAdapter = this.getAdapterUnsynchronized(domainBinding.getComponentBinding(), rangeBinding.getComponentBinding(), typeAdapter, mustClone);
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            int len = domainBinding.size(obj);
                            ArrayList<Object> array = new ArrayList<Object>(len);
                            int i = 0;
                            while (i < len) {
                                Object srcValue = domainBinding.get(obj, i);
                                Object dstValue = componentAdapter.adapt(srcValue);
                                array.add(dstValue);
                                ++i;
                            }
                            return rangeBinding instanceof ArrayListBinding ? array : rangeBinding.create(array);
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = componentAdapter.clones;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof OptionalBinding && range instanceof OptionalBinding) {
                final OptionalBinding domainBinding = (OptionalBinding)domain;
                final OptionalBinding rangeBinding = (OptionalBinding)range;
                final AbstractAdapter componentAdapter = this.getAdapterUnsynchronized(domainBinding.componentBinding, rangeBinding.componentBinding, typeAdapter, mustClone);
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            if (!domainBinding.hasValue(obj)) {
                                return rangeBinding.createNoValue();
                            }
                            Object value = domainBinding.getValue(obj);
                            value = componentAdapter.adapt(value);
                            return rangeBinding.createValue(value);
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.typeAdapter = componentAdapter.typeAdapter;
                result.clones = componentAdapter.clones;
                this.addToCache(req, result);
                return result;
            }
            if (range instanceof OptionalBinding && !(domain instanceof OptionalBinding)) {
                Binding domainBinding = domain;
                final OptionalBinding rangeBinding = (OptionalBinding)range;
                final AbstractAdapter componentAdapter = this.getAdapterUnsynchronized(domainBinding, rangeBinding.componentBinding, typeAdapter, mustClone);
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            obj = componentAdapter.adapt(obj);
                            return rangeBinding.createValue(obj);
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.typeAdapter = componentAdapter.typeAdapter;
                result.clones = componentAdapter.clones;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof VariantBinding && range instanceof VariantBinding) {
                final VariantBinding domainBinding = (VariantBinding)domain;
                final VariantBinding rangeBinding = (VariantBinding)range;
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            Binding domainValueBinding = domainBinding.getContentBinding(obj);
                            Object domainObject = domainBinding.getContent(obj, domainValueBinding);
                            if (mustClone && domainObject != obj) {
                                AbstractAdapter valueAdapter = AdapterFactory.this.getAdapterUnsynchronized(domainValueBinding, domainValueBinding, false, true);
                                domainObject = valueAdapter.adapt(domainObject);
                            }
                            Object rangeVariant = rangeBinding.create(domainValueBinding, domainObject);
                            return rangeVariant;
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                        catch (AdapterConstructionException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = mustClone;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof VariantBinding && !(range instanceof VariantBinding)) {
                final VariantBinding domainBinding = (VariantBinding)domain;
                final Binding rangeBinding = range;
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            Object value = domainBinding.getContent(obj);
                            Binding contentBinding = domainBinding.getContentBinding(obj);
                            AbstractAdapter adapter = (AbstractAdapter)AdapterFactory.this.getAdapter(contentBinding, rangeBinding, this.typeAdapter, mustClone);
                            return adapter.adapt(value);
                        }
                        catch (AdapterConstructionException | BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = mustClone;
                this.addToCache(req, result);
                return result;
            }
            if (range instanceof VariantBinding && !(domain instanceof VariantBinding)) {
                final VariantBinding rangeBinding = (VariantBinding)range;
                final Binding domainBinding = domain;
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            if (mustClone) {
                                AbstractAdapter valueAdapter = AdapterFactory.this.getAdapterUnsynchronized(domainBinding, domainBinding, false, true);
                                obj = valueAdapter.adapt(obj);
                            }
                            return rangeBinding.create(domainBinding, obj);
                        }
                        catch (AdapterConstructionException | BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.clones = mustClone;
                this.addToCache(req, result);
                return result;
            }
            if (domain instanceof MapBinding && range instanceof MapBinding) {
                final MapBinding domainBinding = (MapBinding)domain;
                final MapBinding rangeBinding = (MapBinding)range;
                final AbstractAdapter keyAdapter = this.getAdapterUnsynchronized(domainBinding.getKeyBinding(), rangeBinding.getKeyBinding(), typeAdapter, mustClone);
                final AbstractAdapter valueAdapter = this.getAdapterUnsynchronized(domainBinding.getValueBinding(), rangeBinding.getValueBinding(), typeAdapter, mustClone);
                AbstractAdapter result = new AbstractAdapter(){

                    @Override
                    public Object adapt(Object obj) throws AdaptException {
                        try {
                            int len = domainBinding.size(obj);
                            Object[] domainKeys = domainBinding.getKeys(obj);
                            Object[] domainValues = domainBinding.getValues(obj);
                            Object[] rangeKeys = new Object[len];
                            Object[] rangeValues = new Object[len];
                            int i = 0;
                            while (i < len) {
                                Object domainKey = domainKeys[i];
                                Object domainValue = domainValues[i];
                                Object rangeKey = keyAdapter.adapt(domainKey);
                                Object rangeValue = valueAdapter.adapt(domainValue);
                                rangeKeys[i] = rangeKey;
                                rangeValues[i] = rangeValue;
                                ++i;
                            }
                            Object rangeMap = rangeBinding.create(rangeKeys, rangeValues);
                            return rangeMap;
                        }
                        catch (BindingException e) {
                            throw new AdaptException(e);
                        }
                    }
                };
                result.typeAdapter |= keyAdapter.typeAdapter | valueAdapter.typeAdapter;
                result.clones = keyAdapter.clones & valueAdapter.clones;
                this.addToCache(req, result);
                return result;
            }
        }
        catch (UnitParseException e) {
            throw new AdapterConstructionException(e.getMessage(), e);
        }
        StringBuilder error = new StringBuilder();
        error.append("Could not create ");
        if (mustClone) {
            error.append("cloning ");
        }
        if (typeAdapter) {
            error.append("type");
        }
        error.append("adapter (");
        error.append("domain=");
        error.append(domain.type().toSingleLineString());
        error.append(", range=");
        error.append(range.type().toSingleLineString());
        error.append(")");
        throw new AdapterConstructionException(error.toString());
    }

    public Object adapt(Object value, Binding domain, Binding range) throws AdaptException {
        if (domain == range) {
            return value;
        }
        try {
            if (range instanceof VariantBinding && !(domain instanceof VariantBinding)) {
                return ((VariantBinding)range).create(domain, value);
            }
            return this.getAdapter(domain, range, true, false).adapt(value);
        }
        catch (AdapterConstructionException | BindingException e) {
            throw new AdaptException(e);
        }
    }

    public Object adaptUnchecked(Object value, Binding domain, Binding range) throws RuntimeAdapterConstructionException, RuntimeAdaptException {
        if (domain == range) {
            return value;
        }
        try {
            if (range instanceof VariantBinding && !(domain instanceof VariantBinding)) {
                return ((VariantBinding)range).create(domain, value);
            }
            return this.getAdapter(domain, range, true, false).adaptUnchecked(value);
        }
        catch (RuntimeAdapterConstructionException | RuntimeBindingException e) {
            throw new RuntimeAdaptException(new AdaptException(e.getCause()));
        }
        catch (AdapterConstructionException | BindingException e) {
            throw new RuntimeAdaptException(new AdaptException(e));
        }
    }

    public Object clone(Object value, Binding domain, Binding range) throws AdaptException {
        try {
            return this.getAdapter(domain, range, true, true).adapt(value);
        }
        catch (AdapterConstructionException e) {
            throw new AdaptException(e);
        }
    }

    public Object cloneUnchecked(Object value, Binding domain, Binding range) throws RuntimeAdapterConstructionException, RuntimeAdaptException {
        try {
            return this.getAdapter(domain, range, true, true).adapt(value);
        }
        catch (AdaptException e) {
            throw new RuntimeAdaptException(e);
        }
        catch (RuntimeAdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e.getCause()));
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e));
        }
    }
}

