/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.MapEntryAdded;
import org.simantics.databoard.accessor.event.MapEntryRemoved;
import org.simantics.databoard.accessor.event.ModificationEvent;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileMapAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.MapInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.util.binary.Blob;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class BinaryMap
extends BinaryObject
implements MapAccessor,
FileMapAccessor {
    TreeMap<Object, Reference<BinaryObject>> children;
    Binding kb;
    Binding vb;
    Serializer ks;
    Serializer vs;
    Integer constantSize;
    Index index;
    boolean indexing = false;

    public BinaryMap(BinaryObject parent, Blob blob, Datatype type, AccessorParams params) {
        super(parent, blob, type, params);
        MapType mt = (MapType)type;
        this.kb = params.bindingScheme.getBindingUnchecked(mt.keyType);
        this.vb = params.bindingScheme.getBindingUnchecked(mt.valueType);
        this.ks = params.serializerScheme.getSerializerUnchecked(this.kb);
        this.vs = params.serializerScheme.getSerializerUnchecked(this.vb);
        this.children = new TreeMap(this.kb);
        if (this.ks.getConstantSize() != null && this.vs.getConstantSize() != null) {
            this.constantSize = this.ks.getConstantSize() + this.vs.getConstantSize();
            this.index = new Constant();
        } else {
            this.index = new Sequential();
        }
    }

    BinaryObject getChild(Object key) {
        Reference<BinaryObject> ref = this.children.get(key);
        if (ref == null) {
            return null;
        }
        BinaryObject result = ref.get();
        if (result == null) {
            this.children.remove(key);
            return null;
        }
        return result;
    }

    Entry floorChildEntry(Object key) throws IOException, SerializationException, BindingException {
        if (this.ks.getConstantSize() == null) {
            return null;
        }
        BinaryObject sa = this.getChild(key);
        if (sa != null) {
            if (this.ks.getConstantSize() == null) {
                return null;
            }
            long valuePos = sa.b.getStartPositionInSourceBinary();
            long keyPos = valuePos - (long)this.ks.getConstantSize().intValue();
            return new Entry(key, keyPos, sa);
        }
        return this.lowerChildEntry(key);
    }

    Entry lowerChildEntry(Object key) throws IOException, SerializationException, BindingException {
        if (this.ks.getConstantSize() == null) {
            return null;
        }
        Map.Entry<Object, Reference<BinaryObject>> e = this.children.lowerEntry(key);
        while (e != null) {
            key = e.getKey();
            BinaryObject sa = e.getValue().get();
            if (sa != null) {
                long valuePos = sa.b.getStartPositionInSourceBinary();
                long keyPos = valuePos - (long)this.ks.getConstantSize().intValue();
                return new Entry(key, keyPos, sa);
            }
            this.children.remove(e.getKey());
            e = this.children.lowerEntry(key);
        }
        return null;
    }

    Entry lastChildEntry() throws IOException, SerializationException, BindingException {
        if (this.ks.getConstantSize() == null) {
            return null;
        }
        Map.Entry<Object, Reference<BinaryObject>> e = this.children.lastEntry();
        while (e != null) {
            Object key = e.getKey();
            BinaryObject sa = e.getValue().get();
            if (sa != null) {
                long valuePos = sa.b.getStartPositionInSourceBinary();
                long keyPos = valuePos - (long)this.ks.getConstantSize().intValue();
                return new Entry(key, keyPos, sa);
            }
            this.children.remove(key);
            e = this.children.lowerEntry(key);
        }
        return null;
    }

    Entry higherChildEntry(Object key) throws IOException, SerializationException, BindingException {
        if (this.ks.getConstantSize() == null) {
            return null;
        }
        Map.Entry<Object, Reference<BinaryObject>> e = this.children.higherEntry(key);
        while (e != null) {
            key = e.getKey();
            BinaryObject sa = e.getValue().get();
            if (sa != null) {
                long valuePos = sa.b.getStartPositionInSourceBinary();
                long keyPos = valuePos - (long)this.ks.getConstantSize().intValue();
                return new Entry(key, keyPos, sa);
            }
            this.children.remove(key);
            e = this.children.higherEntry(key);
        }
        return null;
    }

    Entry ceilingChildEntry(Object key) throws IOException, SerializationException, BindingException {
        if (this.ks.getConstantSize() == null) {
            return null;
        }
        BinaryObject sa = this.getChild(key);
        if (sa != null) {
            long valuePos = sa.b.getStartPositionInSourceBinary();
            long keyPos = valuePos - (long)this.ks.getConstantSize().intValue();
            return new Entry(key, keyPos, sa);
        }
        return this.higherChildEntry(key);
    }

    Entry getEntryAt(long pos) throws SerializationException, IOException, BindingException {
        Object k = this.getKeyAt(pos);
        if (k == null) {
            return null;
        }
        return new Entry(k, pos, this.getChild(k));
    }

    Object getKeyAt(long pos) throws SerializationException, IOException, BindingException {
        if (pos < 4L) {
            return null;
        }
        if (pos >= this.b.length()) {
            return null;
        }
        this.b.position(pos);
        Object k = this.ks.deserialize(this.b, null);
        return k;
    }

    @Override
    public MapType type() {
        return (MapType)this.type;
    }

    @Override
    public void clear() throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.clearNoflush();
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public int size() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            if (this.constantSize != null) {
                int n = (int)((this.b.length() - 4L) / (long)this.constantSize.intValue());
                return n;
            }
            this.b.position(0L);
            int n = this.b.readInt();
            return n;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean containsKey(Binding keyBinding, Object key) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Object lk = this.adapt(key, keyBinding, this.kb);
            Entry e = this.index.getKey(lk);
            boolean bl = e != null;
            return bl;
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean containsValue(Binding valueBinding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Serializer vs = this.params.serializerScheme.getSerializer(valueBinding);
            this.b.position(0L);
            int count = this.b.readInt();
            int i = 0;
            while (i < count) {
                this.ks.skip(this.b);
                Object v = vs.deserialize(this.b, null);
                if (valueBinding.equals(v, value)) {
                    return true;
                }
                try {
                    ++i;
                }
                catch (IOException e) {
                    throw new AccessorException(e);
                }
                catch (SerializerConstructionException e) {
                    throw new AccessorException(e);
                }
            }
        }
        finally {
            this.readUnlock();
        }
        return false;
    }

    @Override
    public Object get(Binding keyBinding, Object key, Binding valueBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Object value;
            Object lk = this.adapt(key, keyBinding, this.kb);
            Entry e = this.index.getKey(lk);
            if (e == null) {
                return null;
            }
            this.b.position(e.pos);
            this.ks.skip(this.b, null);
            Object object = value = this.params.serializerScheme.getSerializer(valueBinding).deserialize(this.b, null);
            return object;
        }
        catch (AdaptException e1) {
            throw new AccessorException(e1);
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (RuntimeSerializerConstructionException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void getAll(Binding keyBinding, Binding valueBinding, Map<Object, Object> to) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            try {
                Adapter ka = this.params.adapterScheme.getAdapter(this.kb, keyBinding, true, false);
                Adapter va = this.params.adapterScheme.getAdapter(this.vb, valueBinding, true, false);
                this.b.position(0L);
                int count = this.b.readInt();
                int i = 0;
                while (i < count) {
                    Object k = this.ks.deserialize(this.b, null);
                    Object v = this.vs.deserialize(this.b, null);
                    k = ka.adapt(k);
                    v = va.adapt(v);
                    to.put(k, v);
                    ++i;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void getAll(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            try {
                Adapter ka = this.params.adapterScheme.getAdapter(this.kb, keyBinding, true, false);
                Adapter va = this.params.adapterScheme.getAdapter(this.vb, valueBinding, true, false);
                this.b.position(0L);
                int count = this.b.readInt();
                if (count > keys.length) {
                    throw new AccessorException("keys array too short");
                }
                if (count > values.length) {
                    throw new AccessorException("values array too short");
                }
                int i = 0;
                while (i < count) {
                    Object k = this.ks.deserialize(this.b, null);
                    Object v = this.vs.deserialize(this.b, null);
                    k = ka.adapt(k);
                    v = va.adapt(v);
                    keys[i] = k;
                    values[i] = v;
                    ++i;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int count(Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Entry endEntry;
            Object lf = this.params.adapterScheme.adapt(from, keyBinding, this.kb);
            Object le = this.params.adapterScheme.adapt(end, keyBinding, this.kb);
            Entry fromEntry = fromInclusive ? this.index.ceiling(lf) : this.index.higher(lf);
            Entry entry = endEntry = endInclusive ? this.index.floor(le) : this.index.lower(le);
            if (endEntry == null || fromEntry == null) {
                return 0;
            }
            if (fromEntry.pos > endEntry.pos) {
                return 0;
            }
            if (fromEntry.pos == endEntry.pos) {
                return 1;
            }
            if (this.constantSize != null) {
                int n = (int)((endEntry.pos - fromEntry.pos) / (long)this.constantSize.intValue()) + 1;
                return n;
            }
            int result = 1;
            this.b.position(fromEntry.pos);
            while (this.b.position() < endEntry.pos) {
                this.ks.skip(this.b);
                this.vs.skip(this.b);
                ++result;
            }
            int n = result;
            return n;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getEntries(Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding keyArrayBinding, Object keysArray, ArrayBinding valueArrayBinding, Object valueArray, int limit) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Serializer vs;
            Serializer ks;
            Entry endEntry;
            Object lf = this.params.adapterScheme.adapt(from, keyBinding, this.kb);
            Object le = this.params.adapterScheme.adapt(end, keyBinding, this.kb);
            Entry fromEntry = fromInclusive ? this.index.ceiling(lf) : this.index.higher(lf);
            Entry entry = endEntry = endInclusive ? this.index.floor(le) : this.index.lower(le);
            if (endEntry == null || fromEntry == null) {
                return 0;
            }
            Binding rkb = keyArrayBinding.getComponentBinding();
            Binding rvb = valueArrayBinding.getComponentBinding();
            Datatype lkt = this.type().keyType;
            Datatype lvt = this.type().valueType;
            boolean adaptKey = !rkb.type().equals(lkt);
            boolean adaptValue = !rvb.type().equals(lvt);
            Adapter ka = null;
            Adapter va = null;
            if (adaptKey) {
                Binding lkb = this.params.bindingScheme.getBinding(lkt);
                ka = this.params.adapterScheme.getAdapter(lkb, rkb, true, false);
                ks = this.params.serializerScheme.getSerializer(lkb);
            } else {
                ks = this.params.serializerScheme.getSerializer(rkb);
            }
            if (adaptValue) {
                Binding lvb = this.params.bindingScheme.getBinding(lvt);
                va = this.params.adapterScheme.getAdapter(lvb, rvb, true, false);
                vs = this.params.serializerScheme.getSerializer(lvb);
            } else {
                vs = this.params.serializerScheme.getSerializer(rvb);
            }
            int i = 0;
            int kac = keyArrayBinding.size(keysArray);
            int vac = valueArrayBinding.size(valueArray);
            this.b.position(fromEntry.pos);
            while (this.b.position() <= endEntry.pos) {
                if (limit >= 0 && i >= limit) break;
                Object key = ks.deserialize(this.b);
                if (adaptKey) {
                    key = ka.adapt(key);
                }
                Object value = vs.deserialize(this.b);
                if (adaptValue) {
                    value = va.adapt(value);
                }
                if (i < kac) {
                    keyArrayBinding.set(keysArray, i, key);
                } else {
                    keyArrayBinding.add(keysArray, i, key);
                }
                if (i < vac) {
                    valueArrayBinding.set(valueArray, i, value);
                } else {
                    valueArrayBinding.add(valueArray, i, value);
                }
                ++i;
            }
            int n = i;
            return n;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        catch (BindingConstructionException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getCeilingKey(Binding keyBinding, Object key) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Object lk = this.adapt(key, keyBinding, this.kb);
            if (this.ks.getConstantSize() != null && this.getChild(lk) != null) {
                Object object = key;
                return object;
            }
            Entry e = this.index.ceiling(lk);
            if (e == null) {
                return null;
            }
            Object object = this.adapt(e.key, this.kb, keyBinding);
            return object;
        }
        catch (AdaptException e1) {
            throw new AccessorException(e1);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getFirstKey(Binding keyBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            int count = this.b.readInt();
            if (count == 0) {
                return null;
            }
            Object object = this.params.serializerScheme.getSerializer(keyBinding).deserialize(this.b);
            return object;
        }
        catch (RuntimeSerializerConstructionException e) {
            throw new AccessorException(e);
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getFloorKey(Binding keyBinding, Object key) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Object lk = this.adapt(key, keyBinding, this.kb);
            if (this.ks.getConstantSize() != null && this.getChild(lk) != null) {
                Object object = key;
                return object;
            }
            Entry e = this.index.floor(lk);
            if (e == null) {
                return null;
            }
            Object object = this.adapt(e.key, this.kb, keyBinding);
            return object;
        }
        catch (AdaptException e1) {
            throw new AccessorException(e1);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getHigherKey(Binding keyBinding, Object key) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Object lk = this.adapt(key, keyBinding, this.kb);
            Entry e = this.index.higher(lk);
            if (e == null) {
                return null;
            }
            Object object = this.adapt(e.key, this.kb, keyBinding);
            return object;
        }
        catch (AdaptException e1) {
            throw new AccessorException(e1);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object[] getKeys(Binding keyBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Adapter ka = this.params.adapterScheme.getAdapter(this.kb, keyBinding, true, false);
            this.b.position(0L);
            int count = this.b.readInt();
            Object[] result = new Object[count];
            int i = 0;
            while (i < count) {
                Object k = this.ks.deserialize(this.b, null);
                this.vs.skip(this.b, null);
                result[i] = k = ka.adapt(k);
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        catch (AdaptException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getLastKey(Binding keyBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Entry e = this.index.last();
            if (e == null) {
                return null;
            }
            Object object = this.adapt(e.key, this.kb, keyBinding);
            return object;
        }
        catch (AdaptException e1) {
            throw new AccessorException(e1);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getLowerKey(Binding keyBinding, Object key) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Object lk = this.adapt(key, keyBinding, this.kb);
            Entry e = this.index.lower(lk);
            if (e == null) {
                return null;
            }
            Object object = this.adapt(e.key, this.kb, keyBinding);
            return object;
        }
        catch (AdaptException e1) {
            throw new AccessorException(e1);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            try {
                DataValueRepository rep = new DataValueRepository();
                this.kb.parseValue(lr.label, rep);
                MutableVariant value = rep.get(rep.getValueNames().iterator().next());
                T result = this.getValueAccessor(this.kb, value);
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
            catch (BindingException e1) {
                throw new ReferenceException(e1);
            }
            catch (DataTypeSyntaxError e2) {
                throw new ReferenceException(e2);
            }
        }
        if (reference instanceof KeyReference) {
            KeyReference ref = (KeyReference)reference;
            T result = this.getValueAccessor(ref.key.getBinding(), ref.key.getValue());
            if (reference.getChildReference() != null) {
                result = result.getComponent(reference.getChildReference());
            }
            return result;
        }
        throw new ReferenceException(reference.getClass().getName() + " is not a reference of a map");
    }

    @Override
    public <T extends Accessor> T getValueAccessor(Binding keyBinding, Object key) throws AccessorConstructionException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            long valueSize;
            long valuePos;
            Object rk = key;
            Object lk = this.params.adapterScheme.getAdapter(keyBinding, this.kb, true, true).adapt(rk);
            BinaryObject sa = this.getChild(lk);
            if (sa != null) {
                BinaryObject binaryObject = sa;
                return (T)binaryObject;
            }
            Entry e = this.index.getKey(lk);
            if (e == null) {
                throw new AccessorConstructionException("Map doesn't contain the requested element");
            }
            if (this.ks.getConstantSize() != null) {
                valuePos = e.pos + (long)this.ks.getConstantSize().intValue();
            } else {
                this.b.position(e.pos);
                this.ks.skip(this.b, null);
                valuePos = this.b.position();
            }
            if (this.vs.getConstantSize() != null) {
                valueSize = this.vs.getConstantSize().intValue();
            } else {
                this.b.position(valuePos);
                this.vs.skip(this.b, null);
                valueSize = this.b.position() - valuePos;
            }
            sa = this.createSubAccessor(this.vb.type(), valuePos, valueSize, this.params);
            this.children.put(lk, new SoftReference<BinaryObject>(sa));
            if (this.listeners != null) {
                MutableVariant kv = new MutableVariant(this.kb, lk);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    InterestSet cis;
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    InterestSet gis = is.getComponentInterest();
                    if (gis != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new KeyReference(kv));
                            sa.addListener(le.listener, gis, childPath, le.executor);
                        }
                        catch (AccessorException e1) {
                            throw new AccessorConstructionException(e1);
                        }
                    }
                    if ((cis = is.getComponentInterest(kv)) != null) {
                        try {
                            ChildReference childPath = ChildReference.concatenate(le.path, new KeyReference(kv));
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e1) {
                            throw new AccessorConstructionException(e1);
                        }
                    }
                    le = le.next;
                }
            }
            BinaryObject binaryObject = sa;
            return (T)binaryObject;
        }
        catch (AdaptException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorConstructionException(e);
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AccessorException e) {
            throw new AccessorConstructionException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object[] getValues(Binding valueBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Serializer rvs = this.params.serializerScheme.getSerializer(valueBinding);
            this.b.position(0L);
            int count = this.b.readInt();
            Object[] result = new Object[count];
            int i = 0;
            while (i < result.length) {
                this.ks.skip(this.b, null);
                result[i] = rvs.deserialize(this.b, null);
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setValueNoflush(Binding binding, Object mapValue) throws AccessorException {
        block13: {
            assert (this.b.isOpen());
            MapBinding mb = (MapBinding)binding;
            if (this.children.isEmpty() && this.listeners == null) {
                this.writeLock();
                try {
                    try {
                        Serializer s = this.params.serializerScheme.getSerializer(mb);
                        int size = s.getSize(mapValue, null);
                        this.b.setLength(size);
                        this.b.position(0L);
                        s.serialize(this.b, null, mapValue);
                        break block13;
                    }
                    catch (IOException e) {
                        throw new AccessorException(e);
                    }
                    catch (SerializerConstructionException e) {
                        throw new AccessorException(e);
                    }
                }
                finally {
                    this.writeUnlock();
                }
            }
            this.writeLock();
            try {
                try {
                    int nc = mb.size(mapValue);
                    Object[] nks = new Object[nc];
                    Object[] nvs = new Object[nc];
                    mb.getAll(mapValue, nks, nvs);
                    this.setAllNoflush(mb.getKeyBinding(), mb.getValueBinding(), nks, nvs);
                }
                catch (BindingException e) {
                    throw new AccessorException(e);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    @Override
    public void clearNoflush() throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                boolean hasListeners = this.listeners != null;
                Object[] keys = hasListeners ? this.getKeys(this.kb) : null;
                this.b.position(0L);
                this.b.writeInt(0);
                this.b.setLength(4L);
                for (Reference<BinaryObject> ref : this.children.values()) {
                    BinaryObject sa = ref.get();
                    if (sa == null) continue;
                    sa.invalidatedNotification();
                }
                this.children.clear();
                ListenerEntry le = this.listeners;
                while (le != null) {
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    Object[] objectArray = keys;
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object key = objectArray[n2];
                        MutableVariant var = new MutableVariant(this.kb, key);
                        if (is.inNotificationsOf(var)) {
                            MapEntryRemoved e = new MapEntryRemoved(var);
                            this.emitEvent(le, e);
                        }
                        ++n2;
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void putAllNoflush(Binding keyBinding, Binding valueBinding, Map<Object, Object> from) throws AccessorException {
        int nc = from.size();
        Object[] nks = new Object[nc];
        Object[] nvs = new Object[nc];
        int i = 0;
        for (Map.Entry<Object, Object> e : from.entrySet()) {
            nks[i] = e.getKey();
            nvs[i] = e.getValue();
            ++i;
        }
        this.putAllNoflush(keyBinding, valueBinding, nks, nvs);
    }

    @Override
    public void putAllNoflush(Binding kb, Binding vb, Object[] nks, Object[] nvs) throws AccessorException {
        int c = nks.length;
        int newItemsCount = 0;
        int i = 0;
        while (i < c) {
            boolean hadPreviousValue = this._putNoflush(kb, nks[i], vb, nvs[i]);
            if (!hadPreviousValue) {
                ++newItemsCount;
            }
            ++i;
        }
        if (newItemsCount > 0) {
            assert (this.b.isOpen());
            this.writeLock();
            try {
                try {
                    this.b.position(0L);
                    int oldCount = this.b.readInt();
                    this.b.position(0L);
                    this.b.writeInt(oldCount + newItemsCount);
                }
                catch (IOException e) {
                    throw new AccessorException(e);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    public void setAllNoflush(Binding kb, Binding vb, Object[] nks, Object[] nvs) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                Serializer ks = this.params.serializerScheme.getSerializer(kb);
                Serializer vs = this.params.serializerScheme.getSerializer(vb);
                int nc = nks.length;
                if (this.listeners != null) {
                    this.b.position(4L);
                    int ni = 0;
                    Object nk = nks.length > 0 ? nks[0] : null;
                    Object ok = this.b.length() <= 4L ? null : ks.deserialize(this.b, null);
                    while (nk != null || ok != null) {
                        MapInterestSet is;
                        ListenerEntry le;
                        MutableVariant kv;
                        int c = 0;
                        c = nk == null ? -1 : (ok == null ? 1 : kb.compare(ok, nk));
                        if (c == 0) {
                            kv = new MutableVariant(kb, kb.isImmutable() ? nk : kb.clone(nk));
                            le = this.listeners;
                            while (le != null) {
                                is = (MapInterestSet)le.getInterestSet();
                                if (is.inNotificationsOf(kv)) {
                                    MutableVariant vv = null;
                                    if (is.inValuesOf(kv)) {
                                        Object nv = vb.isImmutable() ? nvs[ni] : vb.clone(nvs[ni]);
                                        vv = new MutableVariant(vb, nv);
                                    }
                                    ValueAssigned e = new ValueAssigned(new KeyReference(kv), vv);
                                    this.emitEvent(le, e);
                                }
                                le = le.next;
                            }
                            nk = ++ni < nks.length ? nks[ni] : null;
                            vs.skip(this.b, null);
                            ok = this.b.position() < this.b.length() ? ks.deserialize(this.b, null) : null;
                            continue;
                        }
                        if (c < 0) {
                            kv = new MutableVariant(kb, kb.isImmutable() ? ok : kb.clone(ok));
                            le = this.listeners;
                            while (le != null) {
                                is = (MapInterestSet)le.getInterestSet();
                                if (is.inNotificationsOf(kv)) {
                                    MapEntryRemoved e = new MapEntryRemoved(kv);
                                    this.emitEvent(le, e);
                                }
                                le = le.next;
                            }
                            vs.skip(this.b, null);
                            ok = this.b.position() < this.b.length() ? ks.deserialize(this.b, null) : null;
                            continue;
                        }
                        if (c <= 0) continue;
                        kv = new MutableVariant(kb, kb.isImmutable() ? nk : kb.clone(nk));
                        if (this.listeners != null) {
                            Object nv = null;
                            ListenerEntry le2 = this.listeners;
                            while (le2 != null) {
                                MapInterestSet is2 = (MapInterestSet)le2.getInterestSet();
                                if (is2.inNotificationsOf(kv)) {
                                    MutableVariant vv = null;
                                    if (is2.inValuesOf(kv)) {
                                        if (nv == null) {
                                            nv = vb.clone(nvs[ni]);
                                        }
                                        vv = new MutableVariant(vb, nv);
                                    }
                                    MapEntryAdded e = new MapEntryAdded(kv, vv);
                                    this.emitEvent(le2, e);
                                }
                                le2 = le2.next;
                            }
                        }
                        Object object = nk = ++ni < nks.length ? nks[ni] : null;
                    }
                }
                long size = 4L;
                if (ks.getConstantSize() != null) {
                    size += (long)nc * (long)ks.getConstantSize().intValue();
                } else {
                    int i = 0;
                    while (i < nc) {
                        size += (long)ks.getSize(nks[i], null);
                        ++i;
                    }
                }
                if (vs.getConstantSize() != null) {
                    size += (long)nc * (long)vs.getConstantSize().intValue();
                } else {
                    int i = 0;
                    while (i < nc) {
                        size += (long)vs.getSize(nvs[i], null);
                        ++i;
                    }
                }
                this.b.setLength(size);
                this.b.position(0L);
                this.b.writeInt(nc);
                int i = 0;
                while (i < nc) {
                    Object nk = nks[i];
                    Object nv = nvs[i];
                    long startPos = this.b.position();
                    ks.serialize(this.b, null, nk);
                    vs.serialize(this.b, null, nv);
                    long endPos = this.b.position();
                    long len = endPos - startPos;
                    Object lk = this.params.adapterScheme.adapt(nk, kb, this.kb);
                    BinaryObject sa = this.getChild(lk);
                    if (sa != null) {
                        sa.b.setPositionInSource(startPos, len);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void putNoflush(Binding kb, Object key, Binding vb, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                boolean hadPreviousEntry = this._putNoflush(kb, key, vb, value);
                if (!hadPreviousEntry) {
                    this.b.position(0L);
                    int oldCount = this.b.readInt();
                    this.b.position(0L);
                    this.b.writeInt(oldCount + 1);
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (RuntimeSerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean _putNoflush(Binding kb, Object key, Binding vb, Object value) throws AccessorException {
        this.writeLock();
        try {
            Object lk = this.adapt(key, kb, this.kb);
            long insertPos = this.index.getInsertPos(lk);
            Serializer ks = this.params.serializerScheme.getSerializer(kb);
            Serializer vs = this.params.serializerScheme.getSerializer(vb);
            long newSize = ks.getSize(key, null) + vs.getSize(value, null);
            if (insertPos < 0L) {
                BinaryObject sa;
                long pos = -insertPos;
                this.b.position(pos);
                this.b.insertBytes(newSize, RandomAccessBinary.ByteSide.Neither);
                this.b.position(pos);
                ks.serialize(this.b, null, key);
                vs.serialize(this.b, null, value);
                MutableVariant kv = new MutableVariant(this.kb, lk);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(kv)) {
                        MutableVariant vv = null;
                        if (is.inValuesOf(kv)) {
                            vv = new MutableVariant(vb, vb.isImmutable() ? value : vb.clone(value));
                        }
                        MapEntryAdded e = new MapEntryAdded(kv, vv);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
                if (insertPos == this.b.length() && this.constantSize == null && (sa = this.getChild(lk)) == null) {
                    try {
                        sa = this.createSubAccessor(vb.type(), pos, newSize, this.params);
                        this.children.put(lk, new SoftReference<BinaryObject>(sa));
                    }
                    catch (AccessorConstructionException accessorConstructionException) {}
                }
                return false;
            }
            Entry e = new Entry(lk, insertPos, null);
            long pos = insertPos;
            long oldSize = this.index.size(e);
            if (oldSize < newSize) {
                this.b.position(pos);
                this.b.insertBytes(newSize - oldSize, RandomAccessBinary.ByteSide.Right);
            } else if (newSize < oldSize) {
                this.b.position(pos);
                this.b.removeBytes(oldSize - newSize, RandomAccessBinary.ByteSide.Right);
            }
            this.b.position(pos);
            ks.serialize(this.b, null, key);
            vs.serialize(this.b, null, value);
            ListenerEntry le = this.listeners;
            if (this.listeners != null) {
                MutableVariant kv = new MutableVariant(kb, lk);
                while (le != null) {
                    MapInterestSet is = (MapInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(kv)) {
                        MutableVariant vv = null;
                        if (is.inValuesOf(kv)) {
                            vv = new MutableVariant(vb, vb.isImmutable() ? value : vb.clone(value));
                        }
                        ValueAssigned ev = new ValueAssigned(new KeyReference(kv), vv);
                        this.emitEvent(le, ev);
                    }
                    le = le.next;
                }
            }
            return true;
        }
        catch (AdaptException e1) {
            throw new AccessorException(e1);
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (RuntimeSerializerConstructionException e) {
            throw new AccessorException(e);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void removeNoflush(Binding keyBinding, Object key) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            Object lk = this.params.adapterScheme.getAdapter(keyBinding, this.kb, true, this.listeners != null).adapt(key);
            Entry e = this.index.getKey(lk);
            if (e == null) {
                return;
            }
            try {
                int oldSize = this.size();
                this.b.position(0L);
                this.b.writeInt(oldSize - 1);
                long size = this.index.size(e);
                this.b.position(e.pos);
                this.b.removeBytes(size, RandomAccessBinary.ByteSide.Right);
                BinaryObject sa = this.getChild(lk);
                if (sa != null) {
                    sa.invalidatedNotification();
                    this.children.remove(lk);
                }
                if (this.listeners != null) {
                    MutableVariant var = new MutableVariant(this.kb, lk);
                    ListenerEntry le = this.listeners;
                    while (le != null) {
                        MapInterestSet is = (MapInterestSet)le.getInterestSet();
                        if (is.inNotificationsOf(var)) {
                            MapEntryRemoved e2 = new MapEntryRemoved(var);
                            this.emitEvent(le, e2);
                        }
                        le = le.next;
                    }
                }
            }
            catch (IOException e2) {
                throw new AccessorException(e2);
            }
            catch (AdaptException e3) {
                throw new AccessorException(e3);
            }
            catch (AdapterConstructionException e4) {
                throw new AccessorException(e4);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        super.addListener(listener, interestSet, path, executor);
        MapInterestSet is = (MapInterestSet)interestSet;
        for (Object key : this.children.keySet()) {
            ChildReference childPath;
            BinaryObject sa = this.getChild(key);
            if (sa == null) continue;
            MutableVariant vkey = new MutableVariant(this.kb, key);
            InterestSet cis = is.getComponentInterest();
            if (cis != null) {
                childPath = ChildReference.concatenate(path, new KeyReference(vkey));
                sa.addListener(listener, cis, childPath, executor);
            }
            if ((cis = is.getComponentInterest(vkey)) == null) continue;
            childPath = ChildReference.concatenate(path, new KeyReference(vkey));
            sa.addListener(listener, cis, childPath, executor);
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        MapInterestSet is = (MapInterestSet)e.interestSet;
        for (Map.Entry<Object, Reference<BinaryObject>> entry : this.children.entrySet()) {
            BinaryObject sa = entry.getValue().get();
            if (sa == null) continue;
            Object key = entry.getKey();
            MutableVariant vkey = new MutableVariant(this.kb, key);
            InterestSet cis = is.getComponentInterest();
            if (cis != null) {
                sa.removeListener(listener);
            }
            if ((cis = is.getComponentInterest(vkey)) == null) continue;
            sa.removeListener(listener);
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ModificationEvent rollback = null;
        if (e instanceof ValueAssigned) {
            try {
                ValueAssigned va = (ValueAssigned)e;
                if (makeRollback) {
                    Binding binding = this.params.bindingScheme.getBinding(this.type());
                    rollback = new ValueAssigned(binding, this.getValue(binding));
                }
                this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
                return rollback;
            }
            catch (BindingConstructionException e1) {
                throw new AccessorException(e1);
            }
        }
        if (e instanceof MapEntryAdded) {
            MapEntryAdded ea = (MapEntryAdded)e;
            if (ea.key == null) {
                throw new AccessorException("Cannot apply entry added event because key is missing");
            }
            if (ea.value == null) {
                throw new AccessorException("Cannot apply entry added event because value is missing");
            }
            boolean hadValue = this.containsKey(ea.key.getBinding(), ea.key.getValue());
            if (hadValue) {
                throw new AccessorException("Could not add entry to key that already existed");
            }
            if (makeRollback) {
                rollback = new MapEntryRemoved(ea.key);
            }
            this.putNoflush(ea.key.getBinding(), ea.key.getValue(), ea.value.getBinding(), ea.value.getValue());
            return rollback;
        }
        if (e instanceof MapEntryRemoved) {
            MapEntryRemoved er = (MapEntryRemoved)e;
            if (makeRollback) {
                boolean hadValue = this.containsKey(er.key.getBinding(), er.key.getValue());
                if (hadValue) {
                    Object oldValueObj = this.get(er.key.getBinding(), er.key.getValue(), this.vb);
                    MutableVariant oldKey = er.key;
                    MutableVariant oldValue = new MutableVariant(this.vb, oldValueObj);
                    rollback = new MapEntryAdded(oldKey, oldValue);
                } else {
                    rollback = new MapEntryRemoved(er.key.clone());
                }
            }
            this.removeNoflush(er.key.getBinding(), er.key.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Map Type");
    }

    @Override
    public void put(Binding keyBinding, Object key, Binding valueBinding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.putNoflush(keyBinding, key, valueBinding, value);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void putAll(Binding keyBinding, Binding valueBinding, Map<Object, Object> from) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.putAllNoflush(keyBinding, valueBinding, from);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void putAll(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.putAllNoflush(keyBinding, valueBinding, keys, values);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void remove(Binding keyBinding, Object key) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.removeNoflush(keyBinding, key);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    class Constant
    extends Index {
        Constant() {
        }

        @Override
        Entry last() throws AccessorException {
            block3: {
                try {
                    if (BinaryMap.this.b.length() > 4L) break block3;
                    return null;
                }
                catch (IOException e) {
                    throw new AccessorException(e);
                }
            }
            long pos = BinaryMap.this.b.length() - (long)BinaryMap.this.constantSize.intValue();
            BinaryMap.this.b.position(pos);
            Object key = BinaryMap.this.ks.deserialize(BinaryMap.this.b);
            return new Entry(key, pos, null);
        }

        @Override
        long getInsertPos(Object key) throws AccessorException {
            int count;
            block8: {
                count = this.count();
                if (count != 0) break block8;
                return -4L;
            }
            try {
                Entry cc;
                int toIndex;
                long pos = BinaryMap.this.b.length() - (long)BinaryMap.this.constantSize.intValue();
                BinaryMap.this.b.position(pos);
                Object lastKey = BinaryMap.this.ks.deserialize(BinaryMap.this.b);
                int c = BinaryMap.this.kb.compare(lastKey, key);
                if (c < 0) {
                    return -BinaryMap.this.b.length();
                }
                if (c == 0) {
                    return pos;
                }
                Entry fc = BinaryMap.this.floorChildEntry(key);
                int fromIndex = fc == null ? 0 : this.indexOf(fc);
                int r = this.binarySearch(fromIndex, toIndex = (cc = BinaryMap.this.ceilingChildEntry(key)) == null ? count : this.indexOf(cc) + 1, key);
                if (r >= 0) {
                    return this.getPos(r);
                }
                if ((r = -(r + 1)) == count) {
                    return -BinaryMap.this.b.length();
                }
                return -this.getPos(r);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }

        int indexOf(Entry e) {
            return (int)((e.pos - 4L) / (long)BinaryMap.this.constantSize.intValue());
        }

        int indexOf(long pos) {
            return (int)((pos - 4L) / (long)BinaryMap.this.constantSize.intValue());
        }

        int binarySearch(int fromIndex, int toIndex, Object key) throws AccessorException {
            int low = fromIndex;
            int high = toIndex - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                Object midVal = this.getKey(mid);
                int cmp = BinaryMap.this.kb.compare(midVal, key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        @Override
        public Entry getKey(Object key) throws AccessorException {
            BinaryObject sa = BinaryMap.this.getChild(key);
            if (sa != null) {
                return new Entry(key, sa.b.getStartPositionInSourceBinary(), sa);
            }
            long pos = this.getInsertPos(key);
            if (pos < 0L) {
                return null;
            }
            return new Entry(key, pos, null);
        }

        @Override
        public long size(Entry e) {
            return BinaryMap.this.constantSize.intValue();
        }

        Object getKey(int index) throws AccessorException {
            try {
                long pos = 4L + (long)index * (long)BinaryMap.this.constantSize.intValue();
                BinaryMap.this.b.position(pos);
                return BinaryMap.this.ks.deserialize(BinaryMap.this.b);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }

        Entry getEntry(int index) throws AccessorException {
            try {
                long pos = 4L + (long)index * (long)BinaryMap.this.constantSize.intValue();
                BinaryMap.this.b.position(pos);
                Object key = BinaryMap.this.ks.deserialize(BinaryMap.this.b);
                return new Entry(key, pos, null);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }

        long getPos(int index) {
            return 4L + (long)index * (long)BinaryMap.this.constantSize.intValue();
        }

        int count() throws IOException {
            return (int)((BinaryMap.this.b.length() - 4L) / (long)BinaryMap.this.constantSize.intValue());
        }

        @Override
        Entry ceiling(Object key) throws AccessorException {
            long pos;
            block5: {
                pos = this.getInsertPos(key);
                if (pos > 0L) {
                    return new Entry(key, pos, BinaryMap.this.getChild(key));
                }
                int index = this.indexOf(pos = -pos);
                if (index < this.count()) break block5;
                return null;
            }
            try {
                key = BinaryMap.this.getKeyAt(pos);
                return new Entry(key, pos, null);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Entry higher(Object key) throws AccessorException {
            try {
                long pos = this.getInsertPos(key);
                if (pos > 0L) {
                    int index = this.indexOf(pos) + 1;
                    if (index >= this.count()) {
                        return null;
                    }
                    pos = this.getPos(index);
                    key = BinaryMap.this.getKeyAt(pos);
                    return new Entry(key, pos, null);
                }
                int index = this.indexOf(-pos);
                if (index >= this.count()) {
                    return null;
                }
                pos = this.getPos(index);
                key = BinaryMap.this.getKeyAt(pos);
                return new Entry(key, pos, null);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Entry lower(Object key) throws AccessorException {
            try {
                long pos = this.getInsertPos(key);
                if (pos > 0L) {
                    int index = this.indexOf(pos) - 1;
                    if (index < 0) {
                        return null;
                    }
                    pos = this.getPos(index);
                    key = BinaryMap.this.getKeyAt(pos);
                    return new Entry(key, pos, null);
                }
                int index = this.indexOf(-pos) - 1;
                if (index < 0) {
                    return null;
                }
                pos = this.getPos(index);
                key = BinaryMap.this.getKeyAt(pos);
                return new Entry(key, pos, null);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        Entry floor(Object key) throws AccessorException {
            int index;
            long pos;
            block5: {
                pos = this.getInsertPos(key);
                if (pos > 0L) {
                    return new Entry(key, pos, BinaryMap.this.getChild(key));
                }
                index = this.indexOf(-pos) - 1;
                if (index >= 0) break block5;
                return null;
            }
            try {
                pos = this.getPos(index);
                key = BinaryMap.this.getKeyAt(pos);
                return new Entry(key, pos, null);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
    }

    static class Entry {
        BinaryObject accessor;
        Object key;
        long pos;

        public Entry(Object key, long pos, BinaryObject accessor) {
            this.key = key;
            this.pos = pos;
            this.accessor = accessor;
        }
    }

    abstract class Index {
        Index() {
        }

        abstract long getInsertPos(Object var1) throws AccessorException;

        abstract Entry getKey(Object var1) throws AccessorException;

        abstract Entry floor(Object var1) throws AccessorException;

        abstract Entry ceiling(Object var1) throws AccessorException;

        abstract Entry higher(Object var1) throws AccessorException;

        abstract Entry lower(Object var1) throws AccessorException;

        abstract long size(Entry var1) throws AccessorException;

        Entry first() throws AccessorException {
            block3: {
                try {
                    BinaryMap.this.b.position(0L);
                    int count = BinaryMap.this.b.readInt();
                    if (count != 0) break block3;
                    return null;
                }
                catch (IOException e) {
                    throw new AccessorException(e);
                }
            }
            Object k = BinaryMap.this.ks.deserialize(BinaryMap.this.b);
            Reference<BinaryObject> ref = BinaryMap.this.children.get(k);
            BinaryObject sa = ref == null ? null : ref.get();
            return new Entry(k, 4L, sa);
        }

        abstract Entry last() throws AccessorException;
    }

    class Sequential
    extends Index {
        Sequential() {
        }

        @Override
        long getInsertPos(Object key) throws AccessorException {
            try {
                Entry start = BinaryMap.this.floorChildEntry(key);
                if (start != null && BinaryMap.this.kb.equals(key, start.key)) {
                    return start.pos;
                }
                long len = BinaryMap.this.b.length();
                long pos = start == null ? 4L : start.pos;
                BinaryMap.this.b.position(pos);
                while (BinaryMap.this.b.position() < len) {
                    pos = BinaryMap.this.b.position();
                    Object k = BinaryMap.this.ks.deserialize(BinaryMap.this.b, null);
                    int c = BinaryMap.this.kb.compare(key, k);
                    if (c == 0) {
                        return pos;
                    }
                    if (c < 0) {
                        return -pos;
                    }
                    BinaryMap.this.vs.skip(BinaryMap.this.b, null);
                }
                return -len;
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        Entry getKey(Object key) throws AccessorException {
            BinaryObject sa = BinaryMap.this.getChild(key);
            if (sa != null) {
                return new Entry(key, sa.b.getStartPositionInSourceBinary(), sa);
            }
            long pos = this.getInsertPos(key);
            if (pos < 0L) {
                return null;
            }
            return new Entry(key, pos, null);
        }

        @Override
        Entry last() throws AccessorException {
            try {
                Entry e = BinaryMap.this.lastChildEntry();
                long startPos = e != null ? e.pos : 4L;
                BinaryMap.this.b.position(startPos);
                Entry result = e != null ? new Entry(e.key, e.pos, e.accessor) : new Entry(null, 0L, null);
                while (BinaryMap.this.b.position() < BinaryMap.this.b.length()) {
                    result.key = BinaryMap.this.ks.deserialize(BinaryMap.this.b, null);
                    result.pos = BinaryMap.this.b.position();
                    BinaryMap.this.vs.skip(BinaryMap.this.b, null);
                    long valueLen = BinaryMap.this.b.position() - result.pos;
                    result.accessor = BinaryMap.this.createSubAccessor(BinaryMap.this.vb.type(), result.pos, valueLen, BinaryMap.this.params);
                    BinaryMap.this.children.put(result.key, new SoftReference<BinaryObject>(result.accessor));
                }
                return result.key == null ? null : result;
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AccessorConstructionException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        long size(Entry e) throws AccessorException {
            try {
                long valueLen;
                long keyLen;
                if (BinaryMap.this.ks.getConstantSize() != null) {
                    keyLen = BinaryMap.this.ks.getConstantSize().intValue();
                } else {
                    BinaryMap.this.b.position(e.pos);
                    BinaryMap.this.ks.skip(BinaryMap.this.b, null);
                    keyLen = BinaryMap.this.b.position() - e.pos;
                }
                if (e.accessor != null) {
                    valueLen = e.accessor.b.length();
                } else if (BinaryMap.this.vs.getConstantSize() != null) {
                    valueLen = BinaryMap.this.vs.getConstantSize().intValue();
                } else {
                    long pos = e.pos + keyLen;
                    BinaryMap.this.b.position(pos);
                    BinaryMap.this.vs.skip(BinaryMap.this.b, null);
                    valueLen = BinaryMap.this.b.position() - pos;
                }
                return keyLen + valueLen;
            }
            catch (IOException e1) {
                throw new AccessorException(e1);
            }
        }

        @Override
        Entry ceiling(Object key) throws AccessorException {
            try {
                long pos = this.getInsertPos(key);
                if (pos > 0L) {
                    return new Entry(key, pos, BinaryMap.this.getChild(key));
                }
                pos = -pos;
                return BinaryMap.this.getEntryAt(pos);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Entry higher(Object key) throws AccessorException {
            try {
                long pos = this.getInsertPos(key);
                if (pos <= 0L) {
                    pos = -pos;
                    return BinaryMap.this.getEntryAt(pos);
                }
                if (pos >= BinaryMap.this.b.length()) {
                    return null;
                }
                BinaryMap.this.b.position(pos);
                BinaryMap.this.ks.skip(BinaryMap.this.b, null);
                BinaryMap.this.vs.skip(BinaryMap.this.b, null);
                return BinaryMap.this.getEntryAt(BinaryMap.this.b.position());
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Entry lower(Object key) throws AccessorException {
            try {
                Entry start = BinaryMap.this.lowerChildEntry(key);
                long len = BinaryMap.this.b.length();
                long pos = start == null ? 4L : start.pos;
                long prevPos = 0L;
                Object k = null;
                Object prevK = null;
                BinaryMap.this.b.position(pos);
                while (true) {
                    if (BinaryMap.this.b.position() >= len) {
                        return new Entry(k, pos, null);
                    }
                    prevPos = pos;
                    pos = BinaryMap.this.b.position();
                    prevK = k;
                    k = BinaryMap.this.ks.deserialize(BinaryMap.this.b, null);
                    long valuePos = BinaryMap.this.b.position();
                    int c = BinaryMap.this.kb.compare(key, k);
                    if (c <= 0) {
                        if (prevK == null) {
                            return null;
                        }
                        return new Entry(prevK, prevPos, null);
                    }
                    BinaryMap.this.vs.skip(BinaryMap.this.b, null);
                    long valueLen = BinaryMap.this.b.position() - valuePos;
                    assert (valueLen >= 0L);
                    Reference<BinaryObject> ref = BinaryMap.this.children.get(k);
                    BinaryObject sa = ref != null ? ref.get() : null;
                    if (sa != null) continue;
                    sa = BinaryMap.this.createSubAccessor(BinaryMap.this.vb.type(), valuePos, valueLen, BinaryMap.this.params);
                    BinaryMap.this.children.put(k, new SoftReference<BinaryObject>(sa));
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AccessorConstructionException e) {
                throw new AccessorException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Entry floor(Object key) throws AccessorException {
            try {
                int c;
                Entry start = BinaryMap.this.floorChildEntry(key);
                if (start != null && BinaryMap.this.kb.equals(key, start.key)) {
                    return start;
                }
                long len = BinaryMap.this.b.length();
                long pos = start == null ? 4L : start.pos;
                long prevPos = 0L;
                Object k = null;
                Object prevK = null;
                BinaryObject prevAccessor = null;
                BinaryMap.this.b.position(pos);
                do {
                    BinaryObject sa;
                    if (BinaryMap.this.b.position() >= len) {
                        return new Entry(k, pos, prevAccessor);
                    }
                    prevPos = pos;
                    pos = BinaryMap.this.b.position();
                    prevK = k;
                    k = BinaryMap.this.ks.deserialize(BinaryMap.this.b, null);
                    long valuePos = BinaryMap.this.b.position();
                    c = BinaryMap.this.kb.compare(key, k);
                    if (c < 0) {
                        if (prevK == null) {
                            return null;
                        }
                        return new Entry(prevK, prevPos, prevAccessor);
                    }
                    BinaryMap.this.vs.skip(BinaryMap.this.b, null);
                    long valueLen = valuePos - pos;
                    Reference<BinaryObject> ref = BinaryMap.this.children.get(k);
                    BinaryObject binaryObject = sa = ref != null ? ref.get() : null;
                    if (sa != null) continue;
                    prevAccessor = BinaryMap.this.createSubAccessor(BinaryMap.this.vb.type(), valuePos, valueLen, BinaryMap.this.params);
                    BinaryMap.this.children.put(k, new SoftReference<BinaryObject>(prevAccessor));
                } while (c != 0);
                return new Entry(k, pos, prevAccessor);
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AccessorConstructionException e) {
                throw new AccessorException(e);
            }
        }
    }
}

