/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.IOException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.FloatAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileFloatAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.FloatInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.util.binary.Blob;

public class BinaryFloat
extends BinaryObject
implements FloatAccessor,
FileFloatAccessor {
    public BinaryFloat(BinaryObject parent, Blob blob, FloatType type, AccessorParams params) throws AccessorConstructionException {
        super(parent, blob, type, params);
        try {
            blob.setLength(4L);
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
    }

    @Override
    public FloatType type() {
        return (FloatType)this.type;
    }

    @Override
    public float getValue() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            float f = this.b.readFloat();
            return f;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ValueAssigned rollback;
        ValueAssigned valueAssigned = rollback = makeRollback ? new ValueAssigned(Bindings.FLOAT, Float.valueOf(this.getValue())) : null;
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            if (va.newValue == null) {
                throw new AccessorException("Float value expected, got null");
            }
            this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Float");
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        throw new ReferenceException(String.valueOf(reference.getClass()) + " is not a subreference of FloatType");
    }

    @Override
    public Object getValue(Binding binding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            FloatBinding bb = (FloatBinding)binding;
            float v = this.getValue();
            Object object = bb.create(v);
            return object;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setValueNoflush(float newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.b.position(0L);
                this.b.writeFloat(newValue);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    FloatInterestSet is = (FloatInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        ValueAssigned e = new ValueAssigned(Bindings.FLOAT, is.inValues() ? Float.valueOf(newValue) : null);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValue(float newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setValueNoflush(newValue);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValueNoflush(Binding binding, Object newValue) throws AccessorException {
        try {
            float nv = ((FloatBinding)binding).getValue_(newValue);
            this.setValueNoflush(nv);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }
}

