/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.IOException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.DoubleAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileDoubleAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.DoubleInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.util.binary.Blob;

public class BinaryDouble
extends BinaryObject
implements DoubleAccessor,
FileDoubleAccessor {
    public BinaryDouble(BinaryObject parent, Blob blob, DoubleType type, AccessorParams params) throws AccessorConstructionException {
        super(parent, blob, type, params);
        try {
            blob.setLength(8L);
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
    }

    @Override
    public DoubleType type() {
        return (DoubleType)this.type;
    }

    @Override
    public double getValue() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            double d = this.b.readDouble();
            return d;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ValueAssigned rollback;
        ValueAssigned valueAssigned = rollback = makeRollback ? new ValueAssigned(Bindings.DOUBLE, this.getValue()) : null;
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            if (va.newValue == null) {
                throw new AccessorException("Double value expected, got null");
            }
            this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Double");
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        throw new ReferenceException(String.valueOf(reference.getClass()) + " is not a subreference of DoubleType");
    }

    @Override
    public Object getValue(Binding binding) throws AccessorException {
        try {
            DoubleBinding bb = (DoubleBinding)binding;
            double v = this.getValue();
            return bb.create(v);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void setValueNoflush(double newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.b.position(0L);
                this.b.writeDouble(newValue);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    DoubleInterestSet is = (DoubleInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        ValueAssigned e = new ValueAssigned(Bindings.DOUBLE, is.inValues() ? Double.valueOf(newValue) : null);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValue(double newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setValueNoflush(newValue);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValueNoflush(Binding binding, Object newValue) throws AccessorException {
        try {
            double nv = ((DoubleBinding)binding).getValue_(newValue);
            this.setValueNoflush(nv);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }
}

