/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/**
 * Reflection Utils
 * 
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public class ReflectionUtils {

	/**
	 * Returns all methods public, protected and private
	 * 
	 * @param clazz
	 * @return all methods
	 */
	public static Method[] getAllMethods(Class<?> clazz)
	{
		Set<Method> result = new HashSet<Method>();				
		_getAllMethods(clazz, result);		
		return result.toArray(new Method[result.size()]);
	}

	public static Field[] getAllFields(Class<?> clazz)
	{
		LinkedList<Class<?>> classes = new LinkedList<Class<?>>();
		while (clazz!=null) {
			classes.addFirst(clazz);
			clazz = clazz.getSuperclass();
		}
		
		ArrayList<Field> result = new ArrayList<Field>();
		for (Class<?> _class : classes) {
			_getAllFields(_class, result);
		}
		
		return result.toArray(new Field[result.size()]);
	}
	
	private static void _getAllFields(Class<?> clazz, Collection<Field> result)
	{
		for (Field m : clazz.getDeclaredFields())
			result.add(m);
	}	
	
	private static void _getAllMethods(Class<?> clazz, Collection<Method> result)
	{
		for (Method m : clazz.getDeclaredMethods())
			result.add(m);
	}
	
}
