/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.util;

/**
 * A generic Pair (2-tuple) structure for containing two object instances of
 * chosen types. Hash and equals are based on identities.
 * 
 * Element order doesn't matter.
 * 
 * @param <T1> type of first element
 * @param <T2> type of second element
 */
public final class IdentityPair<T1, T2> {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public static <T1, T2> IdentityPair<T1, T2> make(T1 t1, T2 t2) {
        return new IdentityPair<T1, T2>(t1, t2);
    }

    public IdentityPair(T1 first, T2 second) {
        //assert(first != null);
        //assert(second != null);
        this.first = first;
        this.second = second;
        this.hash = makeHash();
    }
    
    @Override
    public boolean equals(Object obj) {    	
        if (obj == null)
            return false;
        if (!(obj.getClass().equals(this.getClass())))
            return false;
        IdentityPair<?, ?> other = (IdentityPair<?, ?>) obj;
        return ( (other.first == first) && (other.second == second) ) ||
        ( (other.first == second) && (other.second == first) );
    }
    
    @Override
    public int hashCode() {
        return hash;
    }
    
    @Override
    public String toString() {
        return "<"+first+", "+second+">";
    }
    
    private int makeHash() {
        return (first == null ? 0 : System.identityHashCode(first)) + 
        	(second == null ? 0 : System.identityHashCode(second));
    }
}
