/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.util;

import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;

public class DatatypeVisitorAdapter implements Datatype.Visitor1 {

	protected IdentityHashSet<Datatype> visited = new IdentityHashSet<Datatype>();

	@Override
	public void visit(ArrayType b, Object obj) {
		if ( !visited.add(b) ) return; 
		b.componentType.accept(this, obj);
	}

	@Override
	public void visit(BooleanType b, Object obj) {
	}

	@Override
	public void visit(DoubleType b, Object obj) {
	}

	@Override
	public void visit(FloatType b, Object obj) {
	}

	@Override
	public void visit(IntegerType b, Object obj) {
	}

	@Override
	public void visit(ByteType b, Object obj) {
	}

	@Override
	public void visit(LongType b, Object obj) {
	}

	@Override
	public void visit(OptionalType b, Object obj) {
		if ( !visited.add(b) ) return; 
		b.componentType.accept(this, obj);
	}

	@Override
	public void visit(RecordType b, Object obj) {
		if ( !visited.add(b) ) return; 
		for (int i=0; i<b.getComponentCount(); i++)
			b.getComponent(i).type.accept(this, obj);
	}

	@Override
	public void visit(StringType b, Object obj) {
	}

	@Override
	public void visit(UnionType b, Object obj) {
		if ( !visited.add(b) ) return; 
		for (int i=0; i<b.getComponentCount(); i++)
			b.getComponent(i).type.accept(this, obj);
	}

	@Override
	public void visit(VariantType b, Object obj) {
	}

	@Override
	public void visit(MapType b, Object obj) {
		if ( !visited.add(b) ) return; 
		b.keyType.accept(this, obj);
		b.valueType.accept(this, obj);
	}


}
