package org.simantics.databoard.channel;

import java.util.Collection;

import org.simantics.databoard.binding.mutable.Variant;

/**
 * Command channel is a request-response channel. All operations are asynchronous.
 * This interface is intended to be used by channel clients.   
 * For each callable command there is a commandId and specified datatype for request and error.
 *
 * @author Toni Kalajainen <toni.kalajainen@iki.fi>
 */
public interface CommandChannel {
	
	/**
	 * Invoke a service request. A asynchronous result object is returned 
	 * at-once. <p> 
	 * 
	 * @param commandId command identifier
	 * @param request the request object
	 * @return asynchrouns result object
	 */
	AsyncRequest invoke( Variant commandId, Variant request );
	
	/**
	 * Get all callable commands of the channel.
	 * This result is list of command specifications. For each command there is
	 * unique identification, result type and error type.  
	 * 
	 * @return commands
	 */
	Collection<CommandSpec> getCommands();
	
}
