/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.reflection;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;

/**
 * Binds void.class to {}
 */
public class VoidBinding extends RecordBinding {
		
	public static final Binding VOID_BINDING = new VoidBinding();
	
	public VoidBinding() {
		this.type = RecordType.VOID_TYPE;
		this.componentBindings = new Binding[0];
	}
	
	@Override
	public Object create(Object... value) throws BindingException {
		return null;
	}

	@Override
	public Object getComponent(Object obj, int index)
			throws BindingException {
		throw new BindingException();
	}

	@Override
	public Object createPartial() throws BindingException {
		return null;
	}
	
	@Override
	public void readFrom(Binding srcBinding, Object src, Object dst)
			throws BindingException {
	}

	@Override
	public void setComponents(Object obj, Object... value)
			throws BindingException {
		if (value.length==0) return;
		throw new BindingException();
	}
	
	@Override
	public void setComponent(Object obj, int index, Object value)
			throws BindingException {
		throw new BindingException();
	}

	@Override
	public boolean isInstance(Object obj) {
		return obj==null;
	}

	@Override
	public void setType(Datatype type) {
		super.setType(type);
	}
	
	@Override
	public boolean isImmutable() {
		return true;
	}
}

