/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.mutable;

import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.primitives.MutableDouble;
import org.simantics.databoard.type.DoubleType;

/**
 * Binds DoubleType to {@link MutableDouble}
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class MutableDoubleBinding extends DoubleBinding {

	public MutableDoubleBinding(DoubleType type) {
		super(type);
	}

	@Override
	public Object create(double value) {
		MutableDouble result = new MutableDouble();
		result.value = value;
		return result;
	}

	@Override
	public Object create(Double value) {
		MutableDouble result = new MutableDouble();
		result.value = value;
		return result;
	}

	@Override
	public Object create(Number value) {
		MutableDouble result = new MutableDouble();
		result.value = value.doubleValue();
		return result;
	}

	@Override
	public Object create(String value) throws BindingException {
		try {
			MutableDouble result = new MutableDouble();
			result.value = Double.valueOf(value);
			return result;
		} catch (java.lang.NumberFormatException e) {
			throw new BindingException( e );
		}
	}

	@Override
	public double getValue_(Object o) throws BindingException {
		MutableDouble result = (MutableDouble) o;
		return result.value;
	}

	@Override
	public Double getValue(Object o) throws BindingException {
		MutableDouble result = (MutableDouble) o;
		return result.value;
	}

	@Override
	public boolean isInstance(Object obj) {
		return obj instanceof MutableDouble;
	}

	@Override
	public void setValue(Object obj, double value) throws BindingException {
		MutableDouble result = (MutableDouble) obj;
		result.value = value;
	}

	@Override
	public void setValue(Object obj, Number value) throws BindingException {
		MutableDouble result = (MutableDouble) obj;
		result.value = value.doubleValue();
	}
			
}

