/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.classfactory;

import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.type.Datatype;

public interface TypeClassSubFactory {

	/**
	 * Construct class from datatype. The implementation may use mainFactory 
	 * to construct sub-types. Caching results is not necessary nor recommended. 
	 * 
	 * @param mainFactory
	 * @param type
	 * @return class description or null
	 */
	BindingRequest construct(TypeClassFactory mainFactory, Datatype type) throws BindingConstructionException;
			
}
