/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.reference;


/**
 * Component "value"
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class ComponentReference extends ChildReference {

	public ComponentReference() {
	}

	public ComponentReference(ChildReference child) {
		super(child);
	}

	@Override
	public String toString(boolean labelReference) {
		return "v";
	}
	
	@Override
	public ChildReference clone() {
		return new ComponentReference(childReference==null ? null : childReference.clone());
	}	
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof ComponentReference == false) return false;
		ComponentReference other = (ComponentReference) obj;
		if (other.hasChildReference() != hasChildReference()) return false;
		if (hasChildReference() && !other.childReference.equals(childReference)) return false;
		return true;
	}
	
	@Override
	public int hashCode() {
		int hash = -8882;
		if (hasChildReference()) hash = 31*hash + childReference.hashCode();		
		return hash;
	}	
}

