/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.commandlog.NewChartCommand;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.preference.ChartPreferences;
import org.simantics.charts.preference.ChartTimeWindowTemplate;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.WriteResult;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;

public class NewChart
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource parent = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    NewChart.createChart(parent);
                }
                catch (DatabaseException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.charts", "Failed to create chart.", (Throwable)e));
                }
            }
        };
    }

    public static Resource createChart(final Resource target) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph g) throws DatabaseException {
                g.markUndoPoint();
                Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
                ChartResource wr = ChartResource.getInstance((ReadGraph)g);
                String freshName = NameUtils.findFreshName((ReadGraph)g, (String)"Chart", (Resource)target);
                Resource chart = g.newResource();
                g.claim(chart, l0.InstanceOf, null, wr.TimeSeriesChart);
                g.claimLiteral(chart, l0.HasName, (Object)freshName, (Binding)Bindings.STRING);
                g.claim(chart, l0.PartOf, target);
                IEclipsePreferences pn = InstanceScope.INSTANCE.getNode("org.simantics.charts");
                String templateId = pn.get("chart.default_timewindowtemplate", ChartPreferences.DEFAULT_TIMEWINDOW_TEMPLATE);
                ChartTimeWindowTemplate template = ChartTimeWindowTemplate.getTemplate(templateId);
                if (template != null) {
                    Resource r = g.getResource(template.uri);
                    g.claim(chart, L0X.ObtainsProperty1, null, r);
                }
                String sam = pn.get("chart.axismode", ChartPreferences.DEFAULT_AXISMODE);
                YAxisMode am = YAxisMode.valueOf((String)sam);
                Resource ram = null;
                if (am == YAxisMode.SingleAxis) {
                    ram = wr.YAxisMode_SingleAxis;
                }
                if (am == YAxisMode.MultiAxis) {
                    ram = wr.YAxisMode_MultiAxis;
                }
                if (ram != null) {
                    g.claim(chart, wr.Chart_YAxisMode, ram);
                }
                if (Commands.isRecording()) {
                    Commands.record((Object)g, (Command)new NewChartCommand(chart, target));
                }
                CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
                g.addMetadata((Metadata)cm.add("Created new chart named " + freshName + ", resource " + String.valueOf(chart)));
                return chart;
            }
        });
    }
}

