/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.utils.ui.ISelectionUtils;

public class PropertiesHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection(event);
        List<Resource> list = ISelectionUtils.getPossibleKeys(selection, SelectionHints.KEY_MAIN, Resource.class);
        final Shell shell = HandlerUtil.getActiveShell(event);
        Session session = Simantics.getSession();
        for ( final Resource item : list ) {        	
            session.asyncRequest(new Read<Object>() {
    			@Override
    			public Object perform(ReadGraph graph) throws DatabaseException {
    				ChartResource CHART = ChartResource.getInstance(graph);
    				if ( graph.isInstanceOf(item, CHART.Chart_Item) ) {
    					ChartDoubleClickHandler.openChartItemPropertiesDialog(graph, item, shell.getDisplay());
    				} else
    				if ( graph.isInstanceOf(item, CHART.TimeSeriesChart) ) {
    					ChartDoubleClickHandler.openChartPropertiesDialog(graph, item, shell.getDisplay());
    				} 
    				return null;
    			}});
        }
		return null;
	}

}
