/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.editor;

import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Resource;
import org.simantics.utils.datastructures.hints.HintContext;

/**
 * @author Tuukka Lehtonen
 */
public class ChartKeys {

    /**
     * //@deprecated use {@link #chartSourceKey(Resource)} with model resource as argument instead
     */
    //@Deprecated
    //public static final Key KEY_ACTIVE_CHART_SOURCE = new HintContext.KeyOf(ChartData.class, "CHART_DATA");

    public static ChartSourceKey chartSourceKey(Resource model) {
        return new ChartSourceKey(model);
    }

    /**
     * For having multiple different chart data sources. The sources are
     * identified by resources.
     */
    public static class ChartSourceKey extends HintContext.KeyOf {

        private final Resource source;

        public ChartSourceKey(Resource source) {
            super(ChartData.class, "CHART_DATA(" + source.getResourceId() + ")");
            this.source = source;
        }

        public Resource getResource() {
            return source;
        }

        @Override
        public int hashCode() {
            return source != null ? source.hashCode() : 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (!(obj instanceof ChartSourceKey))
                return false;
            ChartSourceKey other = (ChartSourceKey) obj;
            return ObjectUtils.objectEquals(source, other.source);
        }

        @Override
        public String toString() {
            return getClass().getSimpleName() + "[" + source + "]";
        }

    }

}
