/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.browsing.ui.NodeContext;

public final class NodeContextPath
implements IAdaptable {
    public static final NodeContextPath[] NONE = new NodeContextPath[0];
    public static final NodeContextPath EMPTY = new NodeContextPath(NodeContext.NONE);
    private final NodeContext[] segments;
    private int hash;

    public NodeContextPath(NodeContext ... segments) {
        Assert.isNotNull((Object)segments);
        int i = 0;
        while (i < segments.length) {
            Assert.isNotNull((Object)segments[i]);
            ++i;
        }
        this.segments = segments;
    }

    public NodeContext getSegment(int index) {
        return this.segments[index];
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public NodeContext getFirstSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[0];
    }

    public NodeContext getLastSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public NodeContext[] getSegments() {
        if (this.segments.length == 0) {
            return this.segments;
        }
        return Arrays.copyOf(this.segments, this.segments.length);
    }

    public boolean equals(Object other) {
        if (!(other instanceof NodeContextPath)) {
            return false;
        }
        return this.equals((NodeContextPath)other);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hashCode0();
        }
        return this.hash;
    }

    private int hashCode0() {
        int result = 0;
        int i = 0;
        while (i < this.segments.length) {
            result += this.segments[i].hashCode();
            ++i;
        }
        return result;
    }

    public boolean equals(NodeContextPath otherPath) {
        if (otherPath == null) {
            return false;
        }
        if (this.segments.length != otherPath.segments.length) {
            return false;
        }
        int i = 0;
        while (i < this.segments.length) {
            if (!this.segments[i].equals(otherPath.segments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startsWith(NodeContextPath treePath) {
        int thisSegmentCount = this.getSegmentCount();
        int otherSegmentCount = treePath.getSegmentCount();
        if (otherSegmentCount == thisSegmentCount) {
            return this.equals(treePath);
        }
        if (otherSegmentCount > thisSegmentCount) {
            return false;
        }
        int i = 0;
        while (i < otherSegmentCount) {
            NodeContext otherSegment = treePath.getSegment(i);
            if (!otherSegment.equals(this.segments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public NodeContextPath getParentPath() {
        int segmentCount = this.getSegmentCount();
        if (segmentCount < 1) {
            return null;
        }
        if (segmentCount == 1) {
            return EMPTY;
        }
        NodeContext[] parentSegments = new NodeContext[segmentCount - 1];
        System.arraycopy(this.segments, 0, parentSegments, 0, segmentCount - 1);
        return new NodeContextPath(parentSegments);
    }

    public NodeContextPath createChildPath(NodeContext newSegment) {
        int segmentCount = this.getSegmentCount();
        NodeContext[] childSegments = new NodeContext[segmentCount + 1];
        if (segmentCount > 0) {
            System.arraycopy(this.segments, 0, childSegments, 0, segmentCount);
        }
        childSegments[segmentCount] = newSegment;
        return new NodeContextPath(childSegments);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (NodeContext.class == adapter) {
            return (T)this.getLastSegment();
        }
        NodeContext last = this.getLastSegment();
        if (last instanceof IAdaptable) {
            return (T)last.getAdapter(adapter);
        }
        return null;
    }
}

