/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.Quad;

public class VariableStringPropertyFactory
extends ReadFactoryImpl<Variable, String> {
    private final String format;
    private final Collection<String> properties;

    public VariableStringPropertyFactory(String property) {
        this.properties = Collections.singleton(property);
        this.format = "%1";
    }

    public VariableStringPropertyFactory(String format, String ... properties) {
        this.properties = Arrays.asList(properties);
        this.format = format;
    }

    @Override
    public Object getIdentity(Object inputContents) {
        return new Quad((Object)((Variable)inputContents), (Object)this.format, this.properties, this.getClass());
    }

    public String toString(ReadGraph graph, Variable variable, String property, Object value) throws DatabaseException {
        if (value == null) {
            return "VariableStringPropertyFactory: no value for " + property + " in variable " + String.valueOf(variable);
        }
        if (value instanceof Variable) {
            String result = (String)((Variable)value).getPossiblePropertyValue(graph, "HasName");
            return result;
        }
        return value.toString();
    }

    public String toPossibleString(ReadGraph graph, Variable variable, String property, Object value) throws DatabaseException {
        if (value == null) {
            return "";
        }
        return this.toString(graph, variable, property, value);
    }

    @Override
    public String perform(ReadGraph graph, Variable variable) throws DatabaseException {
        if (variable == null) {
            return "<Error: variable was null>";
        }
        int index = 1;
        String result = this.format;
        for (String property : this.properties) {
            Variable target = variable.browsePossible(graph, property);
            Object targetValue = target != null ? target.getValue(graph) : null;
            String possibleTargetString = this.toPossibleString(graph, variable, property, targetValue);
            result = result.replace("?%" + index, possibleTargetString);
            String targetString = this.toString(graph, variable, property, targetValue);
            result = result.replace("%" + index, targetString);
            ++index;
        }
        return result;
    }
}

