/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.io.IOException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.processors.FilterSelectionRequestQueryProcessor;
import org.simantics.browsing.ui.swt.RootFilterArea;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeContextFilterArea
extends RootFilterArea
implements Widget {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeContextFilterArea.class);
    String preferencePrefix;
    String typeUri;

    public TypeContextFilterArea(GraphExplorer explorer, FilterSelectionRequestQueryProcessor queryProcessor, WidgetSupport support, Composite parent, String id, int style) {
        super(explorer, queryProcessor, parent, style);
        this.preferencePrefix = id + "_TypeFilter_";
        support.register(this);
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        final Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        if (resource == null) {
            return;
        }
        context.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                TypeContextFilterArea.this.setInput(graph, resource);
            }
        });
    }

    public void setInput(ReadGraph graph, Resource resource) throws DatabaseException {
        Resource type = this.getType(graph, resource);
        String typeUri = type == null ? null : graph.getPossibleURI(type);
        this.setTypeURI(typeUri);
    }

    public void setTypeURI(String typeUri) {
        if (typeUri != null) {
            SWTUtils.asyncExec((Display)Display.getDefault(), () -> this.load(typeUri));
        }
    }

    protected Resource getType(ReadGraph graph, Resource resource) throws DatabaseException {
        return graph.getPossibleType(resource, Layer0.getInstance((ReadGraph)graph).Entity);
    }

    @Override
    protected synchronized void applyFilter(NodeContext context, String filter, boolean updateUI) {
        super.applyFilter(context, filter, updateUI);
        if (this.typeUri != null) {
            this.store(this.typeUri, filter);
        }
    }

    private synchronized void store(String typeUri, String filter) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.browsing.ui.swt");
        if (filter != null && filter.length() > 0) {
            store.setValue(this.preferencePrefix + typeUri, filter);
        } else {
            store.setValue(this.preferencePrefix + typeUri, "");
        }
        try {
            store.save();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save filter preference '{}' for type-contextual filter area with type URI {}", new Object[]{filter, typeUri, e});
        }
    }

    private synchronized void load(String typeUri) {
        this.typeUri = typeUri;
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.browsing.ui.swt");
        String filter = store.getString(this.preferencePrefix + typeUri);
        if (filter != null && filter.length() > 0) {
            this.applyFilter(filter);
        }
    }
}

