/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.swt.ModelledAction;
import org.simantics.browsing.ui.swt.ModelledControl;
import org.simantics.browsing.ui.swt.ModelledIcon;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;

public class ModelledButton
implements ModelledControl {
    private final Resource configuration;

    public ModelledButton(Resource configuration) {
        this.configuration = configuration;
    }

    @Override
    public Control create(Composite parent, IWorkbenchSite site, ISessionContext context, WidgetSupport support) throws DatabaseException {
        ModelledAction modelledAction;
        ModelledIcon icon;
        String tooltip;
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Button button = new Button(parent, support, 8);
        GridData gridData = (GridData)Simantics.getSession().syncRequest((Read)new Read<GridData>(){

            public GridData perform(ReadGraph graph) throws DatabaseException {
                Boolean grabExcessHorizontalSpace;
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                GridData data = new GridData(16384, 0x1000000, false, false);
                Integer span = (Integer)graph.getPossibleRelatedValue(ModelledButton.this.configuration, br.Control_HorizontalSpan, (Binding)Bindings.INTEGER);
                if (span != null) {
                    data.horizontalSpan = span;
                }
                if ((grabExcessHorizontalSpace = (Boolean)graph.getPossibleRelatedValue(ModelledButton.this.configuration, br.Control_HorizontalGrab, (Binding)Bindings.BOOLEAN)) != null) {
                    data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
                }
                return data;
            }
        });
        button.setLayoutData(gridData);
        String text = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                return (String)graph.getPossibleRelatedValue(ModelledButton.this.configuration, br.Button_Text);
            }
        });
        if (text != null) {
            button.setText(text);
        }
        if ((tooltip = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                return (String)graph.getPossibleRelatedValue(ModelledButton.this.configuration, br.Button_Tooltip);
            }
        })) != null) {
            button.setTooltipText(tooltip);
        }
        if ((icon = (ModelledIcon)Simantics.getSession().syncRequest((Read)new Read<ModelledIcon>(){

            public ModelledIcon perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource icon = graph.getPossibleObject(ModelledButton.this.configuration, br.Button_Icon);
                if (icon == null) {
                    return null;
                }
                return (ModelledIcon)graph.adapt(icon, ModelledIcon.class);
            }
        })) != null) {
            ImageDescriptor iconDescriptor = icon.create();
            if (iconDescriptor != null) {
                Image image = resourceManager.createImage(iconDescriptor);
                button.setImage(image);
            } else {
                ErrorLogger.defaultLogWarning((String)("Could not load icon " + String.valueOf(icon)), null);
            }
        }
        final Runnable actionRunnable = (modelledAction = (ModelledAction)Simantics.getSession().syncRequest((Read)new Read<ModelledAction>(){

            public ModelledAction perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource action = graph.getPossibleObject(ModelledButton.this.configuration, br.Button_Action);
                if (action == null) {
                    return null;
                }
                return (ModelledAction)graph.adapt(action, ModelledAction.class);
            }
        })) != null ? modelledAction.create(site, context, support) : null;
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (actionRunnable != null) {
                    actionRunnable.run();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return button.getWidget();
    }
}

